/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.web;

import com.jspgou.cms.entity.ShopAdmin;
import com.jspgou.cms.entity.ShopConfig;
import com.jspgou.cms.entity.base.BaseShopAdmin;
import com.jspgou.cms.entity.base.BaseShopMember;
import com.jspgou.cms.manager.ShopAdminMng;
import com.jspgou.cms.manager.ShopConfigMng;
import com.jspgou.cms.manager.ShopMemberMng;
import com.jspgou.cms.service.LoginSvc;
import com.jspgou.cms.web.threadvariable.AdminThread;
import com.jspgou.cms.web.threadvariable.GroupThread;
import com.jspgou.cms.web.threadvariable.MemberThread;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class FrontContextInterceptor
extends HandlerInterceptorAdapter {
    @Autowired
    private ShopConfigMng shopConfigMng;
    @Autowired
    private LoginSvc loginSvc;
    @Autowired
    private ShopMemberMng shopMemberMng;
    @Autowired
    private ShopAdminMng shopAdminMng;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws ServletException {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopConfig config = this.shopConfigMng.findById(web.getId());
        if (config == null) {
            throw new IllegalStateException("no ShopConfig found in Website id=" + web.getId());
        }
        request.setAttribute("_shop_config_key", (Object)config);
        BaseShopMember member = null;
        BaseShopAdmin admin = null;
        Subject subject = SecurityUtils.getSubject();
        if (subject.isAuthenticated()) {
            String username = (String)subject.getPrincipal();
            member = this.shopMemberMng.getByUsername(web.getId(), username);
            admin = this.shopAdminMng.getByUsername(username);
        }
        if (admin != null) {
            Long userId = admin.getAdmin().getUser().getId();
            member = this.shopMemberMng.getByUserId(web.getId(), userId);
            if (member == null && config.getRegisterAuto().booleanValue()) {
                member = this.shopMemberMng.join(userId, web.getId(), config.getRegisterGroup());
            }
            AdminThread.set((ShopAdmin)admin);
        }
        if (member != null) {
            MemberThread.set(member);
            GroupThread.set(member.getGroup());
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        MemberThread.remove();
        GroupThread.remove();
    }
}

