/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.web;

import com.jspgou.cms.service.LoginSvc;
import com.jspgou.cms.web.threadvariable.MemberThread;
import com.jspgou.common.security.annotation.Secured;
import com.jspgou.core.web.front.FrontHelper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class FrontSecureInterceptor
extends HandlerInterceptorAdapter
implements InitializingBean {
    private String loginUrl;
    private LoginSvc loginSvc;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        request.setAttribute("_login_url", (Object)this.loginUrl);
        Secured secured = handler.getClass().getAnnotation(Secured.class);
        if (secured != null && MemberThread.get() == null) {
            this.loginSvc.clearCookie(request, response);
            response.sendRedirect(FrontHelper.getLoginUrl((String)this.loginUrl, (String)request.getContextPath(), (String)request.getRequestURL().toString()));
            return false;
        }
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.loginUrl);
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    @Autowired
    public void setLoginSvc(LoginSvc loginSvc) {
        this.loginSvc = loginSvc;
    }
}

