/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.web;

import com.jspgou.cms.web.ShopFrontHelper;
import com.jspgou.common.web.RequestUtils;
import com.jspgou.common.web.freemarker.DirectiveUtils;
import com.jspgou.common.web.springmvc.MessageResolver;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import freemarker.core.Environment;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.ui.ModelMap;

public class FrontUtils {
    public static final String PARAM_SYS_PAGE = "sysPage";
    public static final String PARAM_USER_PAGE = "userPage";
    public static final String COUNT = "count";
    public static final String FIRST = "first";
    public static final String PAGE_NO = "pageNo";
    public static final String MESSAGE = "message";
    public static final String ARGS = "args";
    public static final String RETURN_URL = "returnUrl";

    public static int getCount(Map<String, TemplateModel> params) throws TemplateException {
        Integer count = DirectiveUtils.getInt((String)COUNT, params);
        if (count == null || count <= 0 || count >= 5000) {
            return 5000;
        }
        return count;
    }

    public static int getFirst(Map<String, TemplateModel> params) throws TemplateException {
        Integer first = DirectiveUtils.getInt((String)FIRST, params);
        if (first == null || first <= 0) {
            return 0;
        }
        return first - 1;
    }

    public static int getPageNo(Environment env) throws TemplateException {
        TemplateModel pageNo = env.getGlobalVariable(PAGE_NO);
        if (pageNo instanceof TemplateNumberModel) {
            return ((TemplateNumberModel)pageNo).getAsNumber().intValue();
        }
        throw new TemplateModelException("'pageNo' not found in DataModel.");
    }

    public static void includePagination(Map<String, TemplateModel> params, Environment env) throws TemplateException, IOException {
        String sysPage = DirectiveUtils.getString((String)PARAM_SYS_PAGE, params);
        String userPage = DirectiveUtils.getString((String)PARAM_USER_PAGE, params);
        if (!StringUtils.isBlank((String)sysPage)) {
            String tpl = "/WEB-INF/t/gou_sys_defined/style_page/channel_" + sysPage + ".html";
            env.include(tpl, "UTF-8", true);
        } else {
            StringUtils.isBlank((String)userPage);
        }
    }

    public static String showMessage(HttpServletRequest request, ModelMap model, String message) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopFrontHelper.setCommonData(request, model, web, 1);
        model.put((Object)MESSAGE, (Object)message);
        return web.getTplSys("common", MessageResolver.getMessage((HttpServletRequest)request, (String)"tpl.messagePage", (Object[])new Object[0]));
    }

    public static String showLogin(HttpServletRequest request, ModelMap model) {
        StringBuilder buff = new StringBuilder("redirect:");
        buff.append("/login.jspx").append("?");
        buff.append(RETURN_URL).append("=");
        buff.append(RequestUtils.getLocation((HttpServletRequest)request));
        return buff.toString();
    }
}

