/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.web;

import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.web.threadvariable.GroupThread;
import com.jspgou.cms.web.threadvariable.MemberThread;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.front.FrontHelper;
import com.jspgou.core.web.front.URLHelper;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.ui.ModelMap;
import org.springframework.web.util.UrlPathHelper;

public abstract class ShopFrontHelper {
    public static void setDynamicPageData(HttpServletRequest request, ModelMap model, Website web, String location, String urlPrefix, String urlSuffix, int pageNo) {
        FrontHelper.setDynamicPageData((HttpServletRequest)request, (ModelMap)model, (Website)web, (String)location, (String)urlPrefix, (String)urlSuffix, (int)pageNo);
        ShopFrontHelper.setShopDate(request, model);
    }

    public static void frontPageData(HttpServletRequest request, Map<String, Object> map) {
        int pageNo = URLHelper.getPageNo((HttpServletRequest)request);
        URLHelper.PageInfo info = URLHelper.getPageInfo((HttpServletRequest)request);
        String href = info.getHref();
        String hrefFormer = info.getHrefFormer();
        String hrefLatter = info.getHrefLatter();
        ShopFrontHelper.frontPageData(pageNo, href, hrefFormer, hrefLatter, map);
    }

    public static void frontPage(HttpServletRequest request, Map<String, Object> map) {
        int pageNo = URLHelper.getPageNo((HttpServletRequest)request);
        URLHelper.PageInfo info = URLHelper.getPageInfo((HttpServletRequest)request);
        String href = info.getHref();
        String hrefFormer = info.getHrefFormer();
        String hrefLatter = info.getHrefLatter();
        ShopFrontHelper.frontPageData(pageNo, href, hrefFormer, hrefLatter, map);
    }

    public static void frontPageData(int pageNo, String href, String hrefFormer, String hrefLatter, Map<String, Object> map) {
        map.put("pageNo", pageNo);
        map.put("href", href);
        map.put("hrefFormer", hrefFormer);
        map.put("hrefLatter", hrefLatter);
    }

    public static void setCommonData(HttpServletRequest request, ModelMap model, Website web, int pageNo) {
        FrontHelper.setCommonData((HttpServletRequest)request, (ModelMap)model, (Website)web, (int)pageNo);
        ShopFrontHelper.setShopDate(request, model);
    }

    public static void setCommon(HttpServletRequest request, ModelMap model, Website web) {
        ShopMember member = (ShopMember)request.getAttribute("_member_key");
        if (member != null) {
            model.addAttribute("member", (Object)member);
            model.addAttribute("group", (Object)GroupThread.get());
        }
        model.addAttribute("config", request.getAttribute("_shop_config_key"));
        FrontHelper.setCommon((HttpServletRequest)request, (ModelMap)model, (Website)web);
    }

    public static void setShopDate(HttpServletRequest request, ModelMap model) {
        model.addAttribute("config", request.getAttribute("_shop_config_key"));
        ShopMember member = MemberThread.get();
        if (member != null) {
            model.addAttribute("member", (Object)member);
            model.addAttribute("group", (Object)GroupThread.get());
        }
    }

    public static String getLocation(HttpServletRequest request) {
        UrlPathHelper helper = new UrlPathHelper();
        StringBuffer buff = request.getRequestURL();
        String uri = request.getRequestURI();
        String origUri = helper.getOriginatingRequestUri(request);
        buff.replace(buff.length() - uri.length(), buff.length(), origUri);
        String queryString = helper.getOriginatingQueryString(request);
        if (queryString != null) {
            buff.append("?").append(queryString);
        }
        return buff.toString();
    }
}

