/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.webservice;

import com.jspgou.cms.entity.ShopAdmin;
import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.entity.ShopMemberGroup;
import com.jspgou.cms.manager.ShopAdminMng;
import com.jspgou.cms.manager.ShopMemberGroupMng;
import com.jspgou.cms.manager.ShopMemberMng;
import com.jspgou.cms.manager.WebserviceAuthMng;
import com.jspgou.cms.manager.WebserviceCallRecordMng;
import com.jspgou.core.entity.Admin;
import com.jspgou.core.entity.Role;
import com.jspgou.core.manager.RoleMng;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

public class UserService
extends SpringBeanAutowiringSupport {
    private static final String SERVICE_CODE_USER_DELETE = "user_delete";
    private static final String SERVICE_CODE_USER_ADD = "user_add";
    private static final String SERVICE_CODE_USER_UPDATE = "user_update";
    private static final String RESPONSE_CODE_SUCCESS = "100";
    private static final String RESPONSE_CODE_AUTH_ERROR = "101";
    private static final String RESPONSE_CODE_PARAM_REQUIRED = "102";
    private static final String RESPONSE_CODE_USER_NOT_FOUND = "103";
    private static final String RESPONSE_CODE_USER_ADD_ERROR = "104";
    private static final String RESPONSE_CODE_USER_UPDATE_ERROR = "105";
    private static final String RESPONSE_CODE_USER_DELETE_ERROR = "106";
    private static final String LOCAL_IP = "127.0.0.1";
    @Autowired
    private ShopAdminMng shopAdminMng;
    @Autowired
    private ShopMemberMng shopMemberMng;
    @Autowired
    private RoleMng roleMng;
    @Autowired
    private ShopMemberGroupMng shopMemberGroupMng;
    @Autowired
    private WebserviceAuthMng webserviceAuthMng;
    @Autowired
    private WebserviceCallRecordMng webserviceCallRecordMng;

    public String addUser(String auth_username, String auth_password, String admin, String username, String password, String email, String realname, String sex, String tel, String groupId, String role, HttpServletRequest request) {
        String responseCode = RESPONSE_CODE_AUTH_ERROR;
        if (this.validate(auth_username, auth_password)) {
            if (StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password)) {
                responseCode = RESPONSE_CODE_PARAM_REQUIRED;
            } else {
                if (StringUtils.isBlank((String)admin)) {
                    admin = "false";
                }
                try {
                    ShopMember shopmember = new ShopMember();
                    shopmember.setRealName(realname);
                    if (StringUtils.isNotBlank((String)sex)) {
                        if (sex.equals("true")) {
                            shopmember.setGender(true);
                        } else if (sex.equals("false")) {
                            shopmember.setGender(false);
                        }
                    }
                    shopmember.setMobile(tel);
                    ShopMemberGroup group = null;
                    if (StringUtils.isNotBlank((String)groupId)) {
                        Long gid = Long.parseLong(groupId);
                        group = this.shopMemberGroupMng.findById(gid);
                    }
                    if (group == null) {
                        group = this.shopMemberGroupMng.findById(1L);
                    }
                    if (admin.equals("false")) {
                        this.shopMemberMng.register(username, password, email, true, null, LOCAL_IP, false, 1L, group.getId());
                    } else if (admin.equals("true")) {
                        Integer[] roleIds = null;
                        if (StringUtils.isNotBlank((String)role)) {
                            String[] roles = role.split(",");
                            roleIds = new Integer[roles.length];
                            int i = 0;
                            while (i < roles.length) {
                                roleIds[i] = Integer.parseInt(roles[i]);
                                ++i;
                            }
                        }
                        ShopAdmin bean = new ShopAdmin();
                        bean.setFirstname(realname);
                        this.shopAdminMng.register(username, password, false, email, LOCAL_IP, false, 1L, bean);
                    }
                    responseCode = RESPONSE_CODE_SUCCESS;
                    this.webserviceCallRecordMng.save(auth_username, SERVICE_CODE_USER_ADD);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    responseCode = RESPONSE_CODE_USER_ADD_ERROR;
                }
            }
        }
        return responseCode;
    }

    public String updateUser(String auth_username, String auth_password, String admin, String username, String password, String email, String realname, String sex, String tel, String groupId, String role) {
        String responseCode = RESPONSE_CODE_AUTH_ERROR;
        if (this.validate(auth_username, auth_password)) {
            if (StringUtils.isBlank((String)username)) {
                responseCode = RESPONSE_CODE_PARAM_REQUIRED;
            } else {
                if (StringUtils.isBlank((String)admin)) {
                    admin = "false";
                }
                ShopMemberGroup group = null;
                if (StringUtils.isNotBlank((String)groupId)) {
                    Long gid = Long.parseLong(groupId);
                    group = this.shopMemberGroupMng.findById(gid);
                }
                if (group == null) {
                    group = this.shopMemberGroupMng.findById(1L);
                }
                ShopMember member = null;
                ShopAdmin user = null;
                if (admin.equals("false")) {
                    member = this.shopMemberMng.getByUsername(null, username);
                    if (member != null) {
                        if (StringUtils.isNotBlank((String)realname)) {
                            member.setRealName(realname);
                        }
                        if (StringUtils.isNotBlank((String)tel)) {
                            member.setMobile(tel);
                        }
                        if (StringUtils.isNotBlank((String)sex)) {
                            member.setGender(Boolean.parseBoolean(sex));
                        }
                        try {
                            this.shopMemberMng.update(member, group.getId(), null, null, null, null, null, password, email, false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            responseCode = RESPONSE_CODE_USER_UPDATE_ERROR;
                        }
                    } else {
                        responseCode = RESPONSE_CODE_USER_NOT_FOUND;
                    }
                } else {
                    user = this.shopAdminMng.getByUsername(username);
                    if (user != null) {
                        try {
                            Integer[] roleIds = null;
                            if (StringUtils.isNotBlank((String)role)) {
                                String[] roles = role.split(",");
                                roleIds = new Integer[roles.length];
                                int i = 0;
                                while (i < roles.length) {
                                    roleIds[i] = Integer.parseInt(roles[i]);
                                    ++i;
                                }
                            }
                            if (user != null) {
                                user.setFirstname(realname);
                                Admin a = user.getAdmin();
                                HashSet<Role> roles = new HashSet<Role>();
                                if (roleIds != null) {
                                    a.getRoles().clear();
                                    Integer[] integerArray = roleIds;
                                    int n = roleIds.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Integer i = integerArray[n2];
                                        roles.add(this.roleMng.findById(i));
                                        ++n2;
                                    }
                                    a.setRoles(roles);
                                }
                                user.setAdmin(a);
                                this.shopAdminMng.update(user, password, false, email, false);
                            }
                            responseCode = RESPONSE_CODE_SUCCESS;
                            this.webserviceCallRecordMng.save(auth_username, SERVICE_CODE_USER_UPDATE);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            responseCode = RESPONSE_CODE_USER_UPDATE_ERROR;
                        }
                    } else {
                        responseCode = RESPONSE_CODE_USER_NOT_FOUND;
                    }
                }
            }
        }
        return responseCode;
    }

    public String delUser(String auth_username, String auth_password, String admin, String username) {
        String responseCode = RESPONSE_CODE_AUTH_ERROR;
        if (this.validate(auth_username, auth_password)) {
            if (StringUtils.isNotBlank((String)username)) {
                if (StringUtils.isNotBlank((String)admin)) {
                    admin = "false";
                }
                if (admin.equals("false")) {
                    ShopMember member = this.shopMemberMng.getByUsername(1L, username);
                    if (member != null) {
                        try {
                            this.shopMemberMng.deleteById(member.getId());
                            responseCode = RESPONSE_CODE_SUCCESS;
                            this.webserviceCallRecordMng.save(auth_username, SERVICE_CODE_USER_DELETE);
                        }
                        catch (Exception e) {
                            responseCode = RESPONSE_CODE_USER_DELETE_ERROR;
                        }
                    } else {
                        responseCode = RESPONSE_CODE_USER_NOT_FOUND;
                    }
                } else {
                    ShopAdmin user = this.shopAdminMng.getByUsername(username);
                    if (user != null) {
                        try {
                            this.shopAdminMng.deleteById(user.getId());
                            responseCode = RESPONSE_CODE_SUCCESS;
                            this.webserviceCallRecordMng.save(auth_username, SERVICE_CODE_USER_DELETE);
                        }
                        catch (Exception e) {
                            responseCode = RESPONSE_CODE_USER_DELETE_ERROR;
                        }
                    } else {
                        responseCode = RESPONSE_CODE_USER_NOT_FOUND;
                    }
                }
            } else {
                responseCode = RESPONSE_CODE_PARAM_REQUIRED;
            }
        }
        return responseCode;
    }

    private boolean validate(String username, String password) {
        if (StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password)) {
            return false;
        }
        return this.webserviceAuthMng.isPasswordValid(username, password);
    }
}

