/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DirtyFlagMap
implements Map,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1433884852607126222L;
    private boolean dirty = false;
    private Map map;
    static /* synthetic */ Class class$java$util$Map$Entry;

    public DirtyFlagMap() {
        this.map = new HashMap();
    }

    public DirtyFlagMap(int initialCapacity) {
        this.map = new HashMap(initialCapacity);
    }

    public DirtyFlagMap(int initialCapacity, float loadFactor) {
        this.map = new HashMap(initialCapacity, loadFactor);
    }

    public void clearDirtyFlag() {
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public Map getWrappedMap() {
        return this.map;
    }

    public void clear() {
        if (!this.map.isEmpty()) {
            this.dirty = true;
        }
        this.map.clear();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object val) {
        return this.map.containsValue(val);
    }

    public Set entrySet() {
        return new DirtyFlagMapEntrySet(this.map.entrySet());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DirtyFlagMap)) {
            return false;
        }
        return ((Object)this.map).equals(((DirtyFlagMap)obj).getWrappedMap());
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return new DirtyFlagSet(this.map.keySet());
    }

    public Object put(Object key, Object val) {
        this.dirty = true;
        return this.map.put(key, val);
    }

    public void putAll(Map t) {
        if (!t.isEmpty()) {
            this.dirty = true;
        }
        this.map.putAll(t);
    }

    public Object remove(Object key) {
        Object obj = this.map.remove(key);
        if (obj != null) {
            this.dirty = true;
        }
        return obj;
    }

    public int size() {
        return this.map.size();
    }

    public Collection values() {
        return new DirtyFlagCollection(this.map.values());
    }

    public Object clone() {
        DirtyFlagMap copy;
        try {
            copy = (DirtyFlagMap)super.clone();
            if (this.map instanceof HashMap) {
                copy.map = (Map)((HashMap)this.map).clone();
            }
        }
        catch (CloneNotSupportedException ex) {
            throw new IncompatibleClassChangeError("Not Cloneable.");
        }
        return copy;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DirtyFlagMapEntry
    implements Map.Entry {
        private Map.Entry entry;

        public DirtyFlagMapEntry(Map.Entry entry) {
            this.entry = entry;
        }

        public Object setValue(Object o) {
            DirtyFlagMap.this.dirty = true;
            return this.entry.setValue(o);
        }

        public Object getKey() {
            return this.entry.getKey();
        }

        public Object getValue() {
            return this.entry.getValue();
        }
    }

    private class DirtyFlagMapEntryIterator
    extends DirtyFlagIterator {
        public DirtyFlagMapEntryIterator(Iterator iterator) {
            super(iterator);
        }

        public Object next() {
            return new DirtyFlagMapEntry((Map.Entry)super.next());
        }
    }

    private class DirtyFlagMapEntrySet
    extends DirtyFlagSet {
        public DirtyFlagMapEntrySet(Set set) {
            super(set);
        }

        public Iterator iterator() {
            return new DirtyFlagMapEntryIterator(this.getWrappedSet().iterator());
        }

        public Object[] toArray() {
            return this.toArray(new Object[super.size()]);
        }

        public Object[] toArray(Object[] array) {
            if (!array.getClass().getComponentType().isAssignableFrom(class$java$util$Map$Entry == null ? (class$java$util$Map$Entry = DirtyFlagMap.class$("java.util.Map$Entry")) : class$java$util$Map$Entry)) {
                throw new IllegalArgumentException("Array must be of type assignable from Map.Entry");
            }
            int size = super.size();
            Object[] result = array.length < size ? (Object[])Array.newInstance(array.getClass().getComponentType(), size) : array;
            Iterator entryIter = this.iterator();
            for (int i = 0; i < size; ++i) {
                result[i] = entryIter.next();
            }
            if (result.length > size) {
                result[size] = null;
            }
            return result;
        }
    }

    private class DirtyFlagIterator
    implements Iterator {
        private Iterator iterator;

        public DirtyFlagIterator(Iterator iterator) {
            this.iterator = iterator;
        }

        public void remove() {
            DirtyFlagMap.this.dirty = true;
            this.iterator.remove();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }
    }

    private class DirtyFlagSet
    extends DirtyFlagCollection
    implements Set {
        public DirtyFlagSet(Set set) {
            super(set);
        }

        protected Set getWrappedSet() {
            return (Set)this.getWrappedCollection();
        }
    }

    private class DirtyFlagCollection
    implements Collection {
        private Collection collection;

        public DirtyFlagCollection(Collection c) {
            this.collection = c;
        }

        protected Collection getWrappedCollection() {
            return this.collection;
        }

        public Iterator iterator() {
            return new DirtyFlagIterator(this.collection.iterator());
        }

        public boolean remove(Object o) {
            boolean removed = this.collection.remove(o);
            if (removed) {
                DirtyFlagMap.this.dirty = true;
            }
            return removed;
        }

        public boolean removeAll(Collection c) {
            boolean changed = this.collection.removeAll(c);
            if (changed) {
                DirtyFlagMap.this.dirty = true;
            }
            return changed;
        }

        public boolean retainAll(Collection c) {
            boolean changed = this.collection.retainAll(c);
            if (changed) {
                DirtyFlagMap.this.dirty = true;
            }
            return changed;
        }

        public void clear() {
            if (!this.collection.isEmpty()) {
                DirtyFlagMap.this.dirty = true;
            }
            this.collection.clear();
        }

        public int size() {
            return this.collection.size();
        }

        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        public boolean contains(Object o) {
            return this.collection.contains(o);
        }

        public boolean add(Object o) {
            return this.add(o);
        }

        public boolean addAll(Collection c) {
            return this.collection.addAll(c);
        }

        public boolean containsAll(Collection c) {
            return this.collection.containsAll(c);
        }

        public Object[] toArray() {
            return this.collection.toArray();
        }

        public Object[] toArray(Object[] array) {
            return this.collection.toArray(array);
        }
    }
}

