/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.common.hibernate3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.type.Type;

public class Finder {
    private StringBuilder hqlBuilder;
    private List<String> params;
    private List<Object> values;
    private List<Type> types;
    private List<String> paramsList;
    private List<Collection<Object>> valuesList;
    private List<Type> typesList;
    private List<String> paramsArray;
    private List<Object[]> valuesArray;
    private List<Type> typesArray;
    private int firstResult = 0;
    private int maxResults = 0;
    private boolean cacheable = false;
    public static final String ROW_COUNT = "select count(*) ";
    public static final String FROM = "from";
    public static final String DISTINCT = "distinct";
    public static final String HQL_FETCH = "fetch";
    public static final String ORDER_BY = "order";

    protected Finder() {
        this.hqlBuilder = new StringBuilder();
    }

    protected Finder(String hql) {
        this.hqlBuilder = new StringBuilder(hql);
    }

    public static Finder create() {
        return new Finder();
    }

    public static Finder create(String hql) {
        return new Finder(hql);
    }

    public Finder append(String hql) {
        this.hqlBuilder.append(hql);
        return this;
    }

    public String getOrigHql() {
        return this.hqlBuilder.toString();
    }

    public String getRowCountHql() {
        String hql = this.hqlBuilder.toString();
        int fromIndex = hql.toLowerCase().indexOf(FROM);
        String projectionHql = hql.substring(0, fromIndex);
        String rowCountHql = (hql = hql.substring(fromIndex)).replace(HQL_FETCH, "");
        int index = rowCountHql.indexOf(ORDER_BY);
        if (index > 0) {
            rowCountHql = rowCountHql.substring(0, index);
        }
        return String.valueOf(this.wrapProjection(projectionHql)) + rowCountHql;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public void setFirstResult(int firstResult) {
        this.firstResult = firstResult;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    public Finder setParam(String param, Object value) {
        return this.setParam(param, value, null);
    }

    public Finder setParam(String param, Object value, Type type) {
        this.getParams().add(param);
        this.getValues().add(value);
        this.getTypes().add(type);
        return this;
    }

    public Finder setParams(Map<String, Object> paramMap) {
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            this.setParam(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Finder setParamList(String name, Collection<Object> vals, Type type) {
        this.getParamsList().add(name);
        this.getValuesList().add(vals);
        this.getTypesList().add(type);
        return this;
    }

    public Finder setParamList(String name, Collection<Object> vals) {
        return this.setParamList(name, vals, null);
    }

    public Finder setParamList(String name, Object[] vals, Type type) {
        this.getParamsArray().add(name);
        this.getValuesArray().add(vals);
        this.getTypesArray().add(type);
        return this;
    }

    public Finder setParamList(String name, Object[] vals) {
        return this.setParamList(name, vals, null);
    }

    public Query setParamsToQuery(Query query) {
        int i;
        if (this.params != null) {
            i = 0;
            while (i < this.params.size()) {
                if (this.types.get(i) == null) {
                    query.setParameter(this.params.get(i), this.values.get(i));
                } else {
                    query.setParameter(this.params.get(i), this.values.get(i), this.types.get(i));
                }
                ++i;
            }
        }
        if (this.paramsList != null) {
            i = 0;
            while (i < this.paramsList.size()) {
                if (this.typesList.get(i) == null) {
                    query.setParameterList(this.paramsList.get(i), this.valuesList.get(i));
                } else {
                    query.setParameterList(this.paramsList.get(i), this.valuesList.get(i), this.typesList.get(i));
                }
                ++i;
            }
        }
        if (this.paramsArray != null) {
            i = 0;
            while (i < this.paramsArray.size()) {
                if (this.typesArray.get(i) == null) {
                    query.setParameterList(this.paramsArray.get(i), this.valuesArray.get(i));
                } else {
                    query.setParameterList(this.paramsArray.get(i), this.valuesArray.get(i), this.typesArray.get(i));
                }
                ++i;
            }
        }
        return query;
    }

    public Query createQuery(Session s) {
        Query query = this.setParamsToQuery(s.createQuery(this.getOrigHql()));
        if (this.getFirstResult() > 0) {
            query.setFirstResult(this.getFirstResult());
        }
        if (this.getMaxResults() > 0) {
            query.setMaxResults(this.getMaxResults());
        }
        if (this.isCacheable()) {
            query.setCacheable(true);
        }
        return query;
    }

    private String wrapProjection(String projection) {
        if (projection.indexOf("select") == -1) {
            return ROW_COUNT;
        }
        return String.valueOf(projection.replace("select", "select count(")) + ") ";
    }

    private List<String> getParams() {
        if (this.params == null) {
            this.params = new ArrayList<String>();
        }
        return this.params;
    }

    private List<Object> getValues() {
        if (this.values == null) {
            this.values = new ArrayList<Object>();
        }
        return this.values;
    }

    private List<Type> getTypes() {
        if (this.types == null) {
            this.types = new ArrayList<Type>();
        }
        return this.types;
    }

    private List<String> getParamsList() {
        if (this.paramsList == null) {
            this.paramsList = new ArrayList<String>();
        }
        return this.paramsList;
    }

    private List<Collection<Object>> getValuesList() {
        if (this.valuesList == null) {
            this.valuesList = new ArrayList<Collection<Object>>();
        }
        return this.valuesList;
    }

    private List<Type> getTypesList() {
        if (this.typesList == null) {
            this.typesList = new ArrayList<Type>();
        }
        return this.typesList;
    }

    private List<String> getParamsArray() {
        if (this.paramsArray == null) {
            this.paramsArray = new ArrayList<String>();
        }
        return this.paramsArray;
    }

    private List<Object[]> getValuesArray() {
        if (this.valuesArray == null) {
            this.valuesArray = new ArrayList<Object[]>();
        }
        return this.valuesArray;
    }

    private List<Type> getTypesArray() {
        if (this.typesArray == null) {
            this.typesArray = new ArrayList<Type>();
        }
        return this.typesArray;
    }

    public static void main(String[] args) {
        Finder find = Finder.create("select distinct p FROM BookType join fetch p");
        System.out.println(find.getRowCountHql());
        System.out.println(find.getOrigHql());
    }
}

