/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.common.hibernate3;

import com.jspgou.common.hibernate3.Finder;
import com.jspgou.common.hibernate3.Updater;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.util.MyBeanUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.transform.ResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public abstract class HibernateBaseDao<T, ID extends Serializable> {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final String ORDER_ENTRIES = "orderEntries";
    protected SessionFactory sessionFactory;

    protected T get(ID id) {
        return this.get(id, false);
    }

    protected T get(ID id, boolean lock) {
        Object entity = lock ? this.getSession().get(this.getEntityClass(), id, LockMode.UPGRADE) : this.getSession().get(this.getEntityClass(), id);
        return (T)entity;
    }

    protected List<T> findByProperty(String property, Object value) {
        Assert.hasText((String)property);
        return this.createCriteria(new Criterion[]{Restrictions.eq((String)property, (Object)value)}).list();
    }

    protected T findUniqueByProperty(String property, Object value) {
        Assert.hasText((String)property);
        Assert.notNull((Object)value);
        return (T)this.createCriteria(new Criterion[]{Restrictions.eq((String)property, (Object)value)}).uniqueResult();
    }

    protected int countByProperty(String property, Object value) {
        Assert.hasText((String)property);
        Assert.notNull((Object)value);
        return ((Number)this.createCriteria(new Criterion[]{Restrictions.eq((String)property, (Object)value)}).setProjection(Projections.rowCount()).uniqueResult()).intValue();
    }

    protected List findByCriteria(Criterion ... criterion) {
        return this.createCriteria(criterion).list();
    }

    public T updateByUpdater(Updater<T> updater) {
        ClassMetadata cm = this.sessionFactory.getClassMetadata(this.getEntityClass());
        T bean = updater.getBean();
        Object po = this.getSession().get(this.getEntityClass(), cm.getIdentifier(bean, EntityMode.POJO));
        this.updaterCopyToPersistentObject(updater, po, cm);
        return (T)po;
    }

    private void updaterCopyToPersistentObject(Updater<T> updater, T po, ClassMetadata cm) {
        String[] propNames = cm.getPropertyNames();
        String identifierName = cm.getIdentifierPropertyName();
        T bean = updater.getBean();
        String[] stringArray = propNames;
        int n = propNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propName = stringArray[n2];
            if (!propName.equals(identifierName)) {
                try {
                    Object value = MyBeanUtils.getSimpleProperty(bean, propName);
                    if (updater.isUpdate(propName, value)) {
                        cm.setPropertyValue(po, propName, value, EntityMode.POJO);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("copy property to persistent object failed: '" + propName + "'", e);
                }
            }
            ++n2;
        }
    }

    protected Criteria createCriteria(Criterion ... criterions) {
        Criteria criteria = this.getSession().createCriteria(this.getEntityClass());
        Criterion[] criterionArray = criterions;
        int n = criterions.length;
        int n2 = 0;
        while (n2 < n) {
            Criterion c = criterionArray[n2];
            criteria.add(c);
            ++n2;
        }
        return criteria;
    }

    protected abstract Class<T> getEntityClass();

    protected List find(String hql, Object ... values) {
        return this.createQuery(hql, values).list();
    }

    protected Object findUnique(String hql, Object ... values) {
        return this.createQuery(hql, values).uniqueResult();
    }

    protected Pagination find(Finder finder, int pageNo, int pageSize) {
        int totalCount = this.countQueryResult(finder);
        Pagination p = new Pagination(pageNo, pageSize, totalCount);
        if (totalCount < 1) {
            p.setList(new ArrayList());
            return p;
        }
        Query query = this.getSession().createQuery(finder.getOrigHql());
        finder.setParamsToQuery(query);
        query.setFirstResult(p.getFirstResult());
        query.setMaxResults(p.getPageSize());
        if (finder.isCacheable()) {
            query.setCacheable(true);
        }
        List list = query.list();
        p.setList(list);
        return p;
    }

    protected List find(Finder finder) {
        Query query = this.getSession().createQuery(finder.getOrigHql());
        finder.setParamsToQuery(query);
        query.setFirstResult(finder.getFirstResult());
        if (finder.getMaxResults() > 0) {
            query.setMaxResults(finder.getMaxResults());
        }
        if (finder.isCacheable()) {
            query.setCacheable(true);
        }
        List list = query.list();
        return list;
    }

    protected Query createQuery(String queryString, Object ... values) {
        Assert.hasText((String)queryString);
        Query queryObject = this.getSession().createQuery(queryString);
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                queryObject.setParameter(i, values[i]);
                ++i;
            }
        }
        return queryObject;
    }

    protected Pagination findByCriteria(Criteria crit, int pageNo, int pageSize) {
        List orderEntries;
        CriteriaImpl impl = (CriteriaImpl)crit;
        Projection projection = impl.getProjection();
        ResultTransformer transformer = impl.getResultTransformer();
        try {
            orderEntries = (List)MyBeanUtils.getFieldValue(impl, ORDER_ENTRIES);
            MyBeanUtils.setFieldValue(impl, ORDER_ENTRIES, new ArrayList());
        }
        catch (Exception e) {
            throw new RuntimeException("cannot read/write 'orderEntries' from CriteriaImpl", e);
        }
        int totalCount = ((Number)crit.setProjection(Projections.rowCount()).uniqueResult()).intValue();
        Pagination p = new Pagination(pageNo, pageSize, totalCount);
        if (totalCount < 1) {
            p.setList(new ArrayList());
            return p;
        }
        crit.setProjection(projection);
        if (projection == null) {
            crit.setResultTransformer(CriteriaSpecification.ROOT_ENTITY);
        }
        if (transformer != null) {
            crit.setResultTransformer(transformer);
        }
        try {
            MyBeanUtils.setFieldValue(impl, ORDER_ENTRIES, orderEntries);
        }
        catch (Exception e) {
            throw new RuntimeException("set 'orderEntries' to CriteriaImpl faild", e);
        }
        crit.setFirstResult(p.getFirstResult());
        crit.setMaxResults(p.getPageSize());
        p.setList(crit.list());
        return p;
    }

    protected int countQueryResult(Finder finder) {
        Query query = this.getSession().createQuery(finder.getRowCountHql());
        finder.setParamsToQuery(query);
        if (finder.isCacheable()) {
            query.setCacheable(true);
        }
        return ((Number)query.iterate().next()).intValue();
    }

    @Autowired
    public void setSessionFactory(SessionFactory sessionfactory) {
        this.sessionFactory = sessionfactory;
    }

    protected Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }
}

