/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.common.page;

import com.jspgou.common.page.Paginable;

public class SimplePage
implements Paginable {
    private static final long serialVersionUID = 1L;
    public static final int DEF_COUNT = 20;
    protected int totalCount = 0;
    protected int pageSize = 20;
    protected int pageNo = 1;

    public static int cpn(Integer pageNo) {
        return pageNo == null || pageNo < 1 ? 1 : pageNo;
    }

    public SimplePage() {
    }

    public SimplePage(int pageNo, int pageSize, int totalCount) {
        this.setTotalCount(totalCount);
        this.setPageSize(pageSize);
        this.setPageNo(pageNo);
        this.adjustPageNo();
    }

    public void adjustPageNo() {
        if (this.pageNo == 1) {
            return;
        }
        int tp = this.getTotalPage();
        if (this.pageNo > tp) {
            this.pageNo = tp;
        }
    }

    @Override
    public int getPageNo() {
        return this.pageNo;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getTotalCount() {
        return this.totalCount;
    }

    @Override
    public int getTotalPage() {
        int totalPage = this.totalCount / this.pageSize;
        if (totalPage == 0 || this.totalCount % this.pageSize != 0) {
            ++totalPage;
        }
        return totalPage;
    }

    @Override
    public boolean isFirstPage() {
        return this.pageNo <= 1;
    }

    @Override
    public boolean isLastPage() {
        return this.pageNo >= this.getTotalPage();
    }

    @Override
    public int getNextPage() {
        if (this.isLastPage()) {
            return this.pageNo;
        }
        return this.pageNo + 1;
    }

    @Override
    public int getPrePage() {
        if (this.isFirstPage()) {
            return this.pageNo;
        }
        return this.pageNo - 1;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount < 0 ? 0 : totalCount;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize < 1 ? 20 : pageSize;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo < 1 ? 1 : pageNo;
    }
}

