/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.common.security.rememberme;

import com.jspgou.common.security.AccountStatusException;
import com.jspgou.common.security.UsernameNotFoundException;
import com.jspgou.common.security.rememberme.CookieTheftException;
import com.jspgou.common.security.rememberme.InvalidCookieException;
import com.jspgou.common.security.rememberme.RememberMeAuthenticationException;
import com.jspgou.common.security.rememberme.RememberMeService;
import com.jspgou.common.security.userdetails.AccountStatusUserDetailsChecker;
import com.jspgou.common.security.userdetails.UserDetails;
import com.jspgou.common.security.userdetails.UserDetailsChecker;
import com.jspgou.common.security.userdetails.UserDetailsService;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractRememberMeServices
implements RememberMeService,
InitializingBean {
    public static final String REMEMBER_ME_COOKIE_KEY = "remember_me_cookie";
    private static final String DELIMITER = ":";
    public static final String DEFAULT_PARAMETER = "remember_me";
    public static final int TWO_WEEKS_S = 1209600;
    private String cookieName = "remember_me_cookie";
    private String parameter = "remember_me";
    private int tokenValiditySeconds = 1209600;
    private boolean alwaysRemember;
    private boolean alwaysRememberCookie;
    private String key;
    private UserDetailsChecker userDetailsChecker = new AccountStatusUserDetailsChecker();
    private UserDetailsService userDetailsService;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public final UserDetails autoLogin(HttpServletRequest request, HttpServletResponse response) throws CookieTheftException {
        String rememberMeCookie = this.extractRememberMeCookie(request);
        if (rememberMeCookie == null) {
            return null;
        }
        this.logger.debug("Remember-me cookie detected");
        UserDetails user = null;
        try {
            String[] cookieTokens = this.decodeCookie(rememberMeCookie);
            user = this.processAutoLoginCookie(cookieTokens, request, response);
            this.userDetailsChecker.check(user);
        }
        catch (CookieTheftException cte) {
            this.cancelCookie(request, response);
            throw cte;
        }
        catch (UsernameNotFoundException noUser) {
            this.cancelCookie(request, response);
            this.logger.debug("Remember-me login was valid but corresponding user not found.", (Throwable)((Object)noUser));
            return null;
        }
        catch (InvalidCookieException invalidCookie) {
            this.cancelCookie(request, response);
            this.logger.debug("Invalid remember-me cookie: " + invalidCookie.getMessage());
            return null;
        }
        catch (AccountStatusException statusInvalid) {
            this.cancelCookie(request, response);
            this.logger.debug("Invalid UserDetails: " + statusInvalid.getMessage());
            return null;
        }
        catch (RememberMeAuthenticationException e) {
            this.cancelCookie(request, response);
            this.logger.debug(e.getMessage());
            return null;
        }
        this.logger.debug("Remember-me cookie accepted");
        return user;
    }

    @Override
    public final boolean loginSuccess(HttpServletRequest request, HttpServletResponse response, UserDetails user) {
        if (!this.rememberMeRequested(request, this.parameter)) {
            this.logger.debug("Remember-me login not requested.");
            return false;
        }
        return this.onLoginSuccess(request, response, user);
    }

    @Override
    public final void loginFail(HttpServletRequest request, HttpServletResponse response) {
        this.logger.debug("Interactive login attempt was unsuccessful.");
        this.cancelCookie(request, response);
        this.onLoginFail(request, response);
    }

    @Override
    public void logout(HttpServletRequest request, HttpServletResponse response) {
        this.logger.debug("Remember-me logout.");
        this.cancelCookie(request, response);
        this.onLogout(request, response);
    }

    protected String extractRememberMeCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        int i = 0;
        while (i < cookies.length) {
            if (this.cookieName.equals(cookies[i].getName())) {
                return cookies[i].getValue();
            }
            ++i;
        }
        return null;
    }

    protected boolean rememberMeRequested(HttpServletRequest request, String parameter) {
        if (this.alwaysRemember) {
            return true;
        }
        String paramValue = request.getParameter(parameter);
        if (paramValue != null && (paramValue.equalsIgnoreCase("true") || paramValue.equalsIgnoreCase("on") || paramValue.equalsIgnoreCase("yes") || paramValue.equals("1"))) {
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Did not send remember-me cookie (principal did not set parameter '" + parameter + "')");
        }
        return false;
    }

    protected void setCookie(String[] tokens, int maxAge, HttpServletRequest request, HttpServletResponse response) {
        String cookieValue = this.encodeCookie(tokens);
        Cookie cookie = new Cookie(this.cookieName, cookieValue);
        String ctx = request.getContextPath();
        cookie.setPath(StringUtils.hasText((String)ctx) ? ctx : "/");
        cookie.setMaxAge(maxAge);
        response.addCookie(cookie);
    }

    protected void cancelCookie(HttpServletRequest request, HttpServletResponse response) {
        this.logger.debug("Cancelling cookie");
        Cookie cookie = new Cookie(this.cookieName, null);
        String ctx = request.getContextPath();
        cookie.setPath(StringUtils.hasText((String)ctx) ? ctx : "/");
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }

    protected String[] decodeCookie(String cookieValue) throws InvalidCookieException {
        StringBuilder sb = new StringBuilder(cookieValue.length() + 3).append(cookieValue);
        int j = 0;
        while (j < sb.length() % 4) {
            sb.append("=");
            ++j;
        }
        cookieValue = sb.toString();
        if (!Base64.isArrayByteBase64((byte[])cookieValue.getBytes())) {
            throw new InvalidCookieException("Cookie token was not Base64 encoded; value was '" + cookieValue + "'");
        }
        String cookieAsPlainText = new String(Base64.decodeBase64((byte[])cookieValue.getBytes()));
        return StringUtils.delimitedListToStringArray((String)cookieAsPlainText, (String)DELIMITER);
    }

    protected String encodeCookie(String[] cookieTokens) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < cookieTokens.length) {
            sb.append(cookieTokens[i]);
            if (i < cookieTokens.length - 1) {
                sb.append(DELIMITER);
            }
            ++i;
        }
        String value = sb.toString();
        sb = new StringBuilder(new String(Base64.encodeBase64((byte[])value.getBytes())));
        while (sb.charAt(sb.length() - 1) == '=') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    protected abstract UserDetails processAutoLoginCookie(String[] var1, HttpServletRequest var2, HttpServletResponse var3) throws RememberMeAuthenticationException, UsernameNotFoundException;

    protected abstract boolean onLoginSuccess(HttpServletRequest var1, HttpServletResponse var2, UserDetails var3);

    protected void onLoginFail(HttpServletRequest request, HttpServletResponse response) {
    }

    protected void onLogout(HttpServletRequest request, HttpServletResponse response) {
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.key);
        Assert.hasLength((String)this.parameter);
        Assert.hasLength((String)this.cookieName);
        Assert.notNull((Object)this.userDetailsService);
    }

    protected String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public boolean isAlwaysRemember() {
        return this.alwaysRemember;
    }

    public void setAlwaysRemember(boolean alwaysRemember) {
        this.alwaysRemember = alwaysRemember;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    protected int getTokenValiditySeconds() {
        return this.tokenValiditySeconds;
    }

    public void setTokenValiditySeconds(int tokenValiditySeconds) {
        this.tokenValiditySeconds = tokenValiditySeconds;
    }

    public boolean isAlwaysRememberCookie() {
        return this.alwaysRememberCookie;
    }

    public void setAlwaysRememberCookie(boolean alwaysRememberCookie) {
        this.alwaysRememberCookie = alwaysRememberCookie;
    }
}

