/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.common.upload;

import com.jspgou.common.upload.Repository;
import com.jspgou.common.upload.UploadUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.multipart.MultipartFile;

public class FileRepository
implements Repository,
ServletContextAware {
    private Logger log = LoggerFactory.getLogger(FileRepository.class);
    private ServletContext ctx;

    public String storeByExt(String path, String ext, MultipartFile file) throws IOException {
        String filename = UploadUtils.generateFilename(path, ext);
        File dest = new File(this.ctx.getRealPath(filename));
        dest = UploadUtils.getUniqueFile(dest);
        this.stores(file, dest);
        return filename;
    }

    private void stores(MultipartFile file, File dest) throws IOException {
        try {
            UploadUtils.checkDirAndCreate(dest.getParentFile());
            file.transferTo(dest);
        }
        catch (IOException e) {
            this.log.error("Transfer file error when upload file", (Throwable)e);
            throw e;
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.ctx = servletContext;
    }

    @Override
    public boolean store(String s, InputStream inputstream) throws FileNotFoundException, IOException {
        IOUtils.copy((InputStream)inputstream, (OutputStream)new FileOutputStream(this.ctx.getRealPath(s)));
        return true;
    }

    @Override
    public boolean retrieve(String s, OutputStream outputstream) {
        return false;
    }
}

