/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class PropertyUtils
implements BeanFactoryAware {
    private BeanFactory beanFactory;
    private Properties properties;

    public List<String> getList(String prefix) {
        if (this.properties == null || prefix == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<?> en = this.properties.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!key.startsWith(prefix)) continue;
            list.add(this.properties.getProperty(key));
        }
        return list;
    }

    public Set<String> getSet(String prefix) {
        if (this.properties == null || prefix == null) {
            return Collections.emptySet();
        }
        TreeSet<String> set = new TreeSet<String>();
        Enumeration<?> en = this.properties.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!key.startsWith(prefix)) continue;
            set.add(this.properties.getProperty(key));
        }
        return set;
    }

    public Map<String, String> getMap(String prefix) {
        if (this.properties == null || prefix == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<?> en = this.properties.propertyNames();
        int len = prefix.length();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!key.startsWith(prefix)) continue;
            map.put(key.substring(len), this.properties.getProperty(key));
        }
        return map;
    }

    public Properties getProperties(String prefix) {
        Properties props = new Properties();
        if (this.properties == null || prefix == null) {
            return props;
        }
        Enumeration<?> en = this.properties.propertyNames();
        int len = prefix.length();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!key.startsWith(prefix)) continue;
            props.put(key.substring(len), this.properties.getProperty(key));
        }
        return props;
    }

    public String getPropertiesString(String prefix) {
        String property = "";
        if (this.properties == null || prefix == null) {
            return property;
        }
        Enumeration<?> en = this.properties.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!key.equals(prefix)) continue;
            return this.properties.getProperty(key);
        }
        return property;
    }

    public Map<String, Object> getBeanMap(String prefix) {
        Map<String, String> keyMap = this.getMap(prefix);
        if (keyMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(keyMap.size());
        for (Map.Entry<String, String> entry : keyMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            resultMap.put(key, this.beanFactory.getBean(value, Object.class));
        }
        return resultMap;
    }

    public static Properties getProperties(File file) {
        Properties props = new Properties();
        try {
            FileInputStream in = new FileInputStream(file);
            props.load(in);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return props;
    }

    public static String getPropertyValue(File file, String key) {
        Properties props = PropertyUtils.getProperties(file);
        return (String)props.get(key);
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

