/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class Zipper {
    private static final Logger log = LoggerFactory.getLogger(Zipper.class);
    private byte[] buf = new byte[1024];
    private ZipOutputStream zipOut;

    public static void zip(OutputStream out, List<FileEntry> fileEntrys, String encoding) {
        new Zipper(out, fileEntrys, encoding);
    }

    public static void zip(OutputStream out, List<FileEntry> fileEntrys) {
        new Zipper(out, fileEntrys, null);
    }

    protected Zipper(OutputStream out, List<FileEntry> fileEntrys, String encoding) {
        Assert.notEmpty(fileEntrys);
        long begin = System.currentTimeMillis();
        log.debug("\u5f00\u59cb\u5236\u4f5c\u538b\u7f29\u5305");
        try {
            try {
                this.zipOut = new ZipOutputStream(out);
                if (!StringUtils.isBlank((String)encoding)) {
                    log.debug("using encoding: {}", (Object)encoding);
                    this.zipOut.setEncoding(encoding);
                } else {
                    log.debug("using default encoding");
                }
                for (FileEntry fe : fileEntrys) {
                    this.zip(fe.getFile(), fe.getFilter(), fe.getZipEntry(), fe.getPrefix());
                }
            }
            finally {
                this.zipOut.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u5236\u4f5c\u538b\u7f29\u5305\u65f6\uff0c\u51fa\u73b0IO\u5f02\u5e38\uff01", e);
        }
        long end = System.currentTimeMillis();
        log.info("\u5236\u4f5c\u538b\u7f29\u5305\u6210\u529f\u3002\u8017\u65f6\uff1a{}ms\u3002", (Object)(end - begin));
    }

    private void zip(File srcFile, FilenameFilter filter, ZipEntry pentry, String prefix) throws IOException {
        if (srcFile.isDirectory()) {
            File[] files;
            ZipEntry entry = pentry == null ? new ZipEntry(srcFile.getName()) : new ZipEntry(String.valueOf(pentry.getName()) + "/" + srcFile.getName());
            File[] fileArray = files = srcFile.listFiles(filter);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.zip(f, filter, entry, prefix);
                ++n2;
            }
        } else {
            ZipEntry entry = pentry == null ? new ZipEntry(String.valueOf(prefix) + srcFile.getName()) : new ZipEntry(String.valueOf(pentry.getName()) + "/" + prefix + srcFile.getName());
            try {
                log.debug("\u8bfb\u53d6\u6587\u4ef6\uff1a{}", (Object)srcFile.getAbsolutePath());
                FileInputStream in = new FileInputStream(srcFile);
                try {
                    int len;
                    this.zipOut.putNextEntry(entry);
                    while ((len = in.read(this.buf)) > 0) {
                        this.zipOut.write(this.buf, 0, len);
                    }
                    this.zipOut.closeEntry();
                }
                finally {
                    in.close();
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("\u5236\u4f5c\u538b\u7f29\u5305\u65f6\uff0c\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + srcFile.getAbsolutePath(), e);
            }
        }
    }

    public static class FileEntry {
        private FilenameFilter filter;
        private String parent;
        private File file;
        private String prefix;

        public FileEntry(String parent, String prefix, File file, FilenameFilter filter) {
            this.parent = parent;
            this.prefix = prefix;
            this.file = file;
            this.filter = filter;
        }

        public FileEntry(String parent, File file) {
            this.parent = parent;
            this.file = file;
        }

        public FileEntry(String parent, String prefix, File file) {
            this(parent, prefix, file, null);
        }

        public ZipEntry getZipEntry() {
            if (StringUtils.isBlank((String)this.parent)) {
                return null;
            }
            return new ZipEntry(this.parent);
        }

        public FilenameFilter getFilter() {
            return this.filter;
        }

        public void setFilter(FilenameFilter filter) {
            this.filter = filter;
        }

        public String getParent() {
            return this.parent;
        }

        public void setParent(String parent) {
            this.parent = parent;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public String getPrefix() {
            if (this.prefix == null) {
                return "";
            }
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }
    }
}

