/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.common.web;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UrlPathHelper;

public class RequestUtils {
    private static final Logger log = LoggerFactory.getLogger(RequestUtils.class);

    public static String getQueryParam(HttpServletRequest request, String name) {
        String[] as;
        String s = request.getQueryString();
        if (StringUtils.isBlank((String)s)) {
            return null;
        }
        try {
            s = URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("encoding UTF-8 not support?", (Throwable)e);
        }
        if (StringUtils.isBlank((String)s)) {
            return null;
        }
        String[] as1 = as = StringUtils.split((String)s, (String)"&");
        int i = as1.length;
        int j = 0;
        while (j < i) {
            String s2 = as1[j];
            String[] as2 = StringUtils.split((String)s2, (String)"=");
            int k = as2.length;
            if (k >= 1 && as2[0].equals(name)) {
                if (k == 2) {
                    return as2[1];
                }
                return "";
            }
            ++j;
        }
        return null;
    }

    public static Map<String, Object> getQueryParams(HttpServletRequest request) {
        Map<String, String[]> map;
        if (request.getMethod().equalsIgnoreCase("POST")) {
            map = request.getParameterMap();
        } else {
            String s = request.getQueryString();
            if (StringUtils.isBlank((String)s)) {
                return new HashMap<String, Object>();
            }
            try {
                s = URLDecoder.decode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("encoding UTF-8 not support?", (Throwable)e);
            }
            map = RequestUtils.parseQueryString(s);
        }
        HashMap<String, Object> params = new HashMap<String, Object>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            int len = ((String[])entry.getValue()).length;
            if (len == 1) {
                params.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
                continue;
            }
            if (len <= 1) continue;
            params.put((String)entry.getKey(), entry.getValue());
        }
        return params;
    }

    public static Map<String, String[]> parseQueryString(String s) {
        String[] valArray = null;
        if (s == null) {
            throw new IllegalArgumentException();
        }
        HashMap<String, String[]> ht = new HashMap<String, String[]>();
        StringTokenizer st = new StringTokenizer(s, "&");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) continue;
            String key = pair.substring(0, pos);
            String val = pair.substring(pos + 1, pair.length());
            if (ht.containsKey(key)) {
                String[] oldVals = (String[])ht.get(key);
                valArray = new String[oldVals.length + 1];
                int i = 0;
                while (i < oldVals.length) {
                    valArray[i] = oldVals[i];
                    ++i;
                }
                valArray[oldVals.length] = val;
            } else {
                valArray = new String[]{val};
            }
            ht.put(key, valArray);
        }
        return ht;
    }

    public static String getLocation(HttpServletRequest request) {
        UrlPathHelper helper = new UrlPathHelper();
        StringBuffer buff = request.getRequestURL();
        String uri = request.getRequestURI();
        String origUri = helper.getOriginatingRequestUri(request);
        buff.replace(buff.length() - uri.length(), buff.length(), origUri);
        String queryString = helper.getOriginatingQueryString(request);
        if (queryString != null) {
            buff.append("?").append(queryString);
        }
        return buff.toString();
    }

    public static Map<String, String> getRequestMap(HttpServletRequest request, String prefix) {
        return RequestUtils.getRequestMap(request, prefix, false);
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-Real-IP");
        if (!StringUtils.isBlank((String)ip) && !"unknown".equalsIgnoreCase(ip)) {
            return ip;
        }
        ip = request.getHeader("X-Forwarded-For");
        if (!StringUtils.isBlank((String)ip) && !"unknown".equalsIgnoreCase(ip)) {
            int index = ip.indexOf(44);
            if (index != -1) {
                return ip.substring(0, index);
            }
            return ip;
        }
        return request.getRemoteAddr();
    }

    private static Map<String, String> getRequestMap(HttpServletRequest request, String prefix, boolean nameWithPrefix) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(prefix)) continue;
            String key = nameWithPrefix ? name : name.substring(prefix.length());
            String value = StringUtils.join((Object[])request.getParameterValues(name), (char)',');
            map.put(key, value);
        }
        return map;
    }

    public static void main(String[] args) {
        System.out.println(StringUtils.split((String)"", (String)"=").length);
    }
}

