/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.common.web;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    public static final String UTF8 = "UTF-8";
    private String[] filterChars;
    private String[] replaceChars;

    public XssHttpServletRequestWrapper(HttpServletRequest request, String filterChar, String replaceChar, String splitChar) {
        super(request);
        if (filterChar != null && filterChar.length() > 0) {
            this.filterChars = filterChar.split(splitChar);
        }
        if (replaceChar != null && replaceChar.length() > 0) {
            this.replaceChars = replaceChar.split(splitChar);
        }
    }

    public String getQueryString() {
        String value = super.getQueryString();
        if (value != null) {
            value = this.xssEncode(value);
        }
        return value;
    }

    public String getParameter(String name) {
        String value = super.getParameter(this.xssEncode(name));
        if (value != null) {
            value = this.xssEncode(value);
        }
        return value;
    }

    public String[] getParameterValues(String name) {
        String[] parameters = super.getParameterValues(name);
        if (parameters == null || parameters.length == 0) {
            return null;
        }
        int i = 0;
        while (i < parameters.length) {
            parameters[i] = this.xssEncode(parameters[i]);
            ++i;
        }
        return parameters;
    }

    public String getHeader(String name) {
        String value = super.getHeader(this.xssEncode(name));
        if (value != null) {
            value = this.xssEncode(value);
        }
        return value;
    }

    private String xssEncode(String s) {
        if (s == null || s.equals("")) {
            return s;
        }
        try {
            s = URLDecoder.decode(s, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            // empty catch block
        }
        int i = 0;
        while (i < this.filterChars.length) {
            if (s.contains(this.filterChars[i])) {
                s = s.replace(this.filterChars[i], this.replaceChars[i]);
            }
            ++i;
        }
        return s;
    }
}

