/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.common.web.session;

import com.jspgou.common.web.session.SessionProvider;
import com.jspgou.common.web.session.cache.SessionCache;
import com.jspgou.common.web.session.id.SessionIdGenerator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class CacheSessionProvider
implements SessionProvider,
InitializingBean {
    public static final String CURRENT_SESSION = "_current_session";
    public static final String CURRENT_SESSION_ID = "_current_session_id";
    private SessionCache sessionCache;
    private SessionIdGenerator sessionIdGenerator;
    private int sessionTimeout = 30;

    @Override
    public Serializable getAttribute(HttpServletRequest request, String name) {
        Map<String, Serializable> session = (Map<String, Serializable>)request.getAttribute(CURRENT_SESSION);
        if (session != null) {
            return (Serializable)session.get(name);
        }
        String root = (String)request.getAttribute(CURRENT_SESSION_ID);
        if (root == null) {
            root = request.getRequestedSessionId();
        }
        if (StringUtils.isBlank((String)root)) {
            request.setAttribute(CURRENT_SESSION, new HashMap());
            return null;
        }
        session = this.sessionCache.getSession(root);
        if (session != null) {
            request.setAttribute(CURRENT_SESSION_ID, (Object)root);
            request.setAttribute(CURRENT_SESSION, session);
            return session.get(name);
        }
        return null;
    }

    @Override
    public void setAttribute(HttpServletRequest request, HttpServletResponse response, String name, Serializable value) {
        String root;
        HashMap<String, Serializable> session = (HashMap<String, Serializable>)request.getAttribute(CURRENT_SESSION);
        if (session == null) {
            root = request.getRequestedSessionId();
            if (root != null && root.length() == 32) {
                session = this.sessionCache.getSession(root);
            }
            if (session == null) {
                session = new HashMap<String, Serializable>();
                while (this.sessionCache.exist(root = this.sessionIdGenerator.get())) {
                }
                response.addCookie(this.createCookie(request, root));
            }
            request.setAttribute(CURRENT_SESSION, session);
            request.setAttribute(CURRENT_SESSION_ID, (Object)root);
        } else {
            root = (String)request.getAttribute(CURRENT_SESSION_ID);
            if (root == null) {
                while (this.sessionCache.exist(root = this.sessionIdGenerator.get())) {
                }
                response.addCookie(this.createCookie(request, root));
                request.setAttribute(CURRENT_SESSION_ID, (Object)root);
            }
        }
        session.put(name, value);
        this.sessionCache.setSession(root, session, this.sessionTimeout);
    }

    @Override
    public String getSessionId(HttpServletRequest request, HttpServletResponse response) {
        String root = (String)request.getAttribute(CURRENT_SESSION_ID);
        if (root != null) {
            return root;
        }
        root = request.getRequestedSessionId();
        if (root == null || root.length() != 32 || !this.sessionCache.exist(root)) {
            while (this.sessionCache.exist(root = this.sessionIdGenerator.get())) {
            }
            this.sessionCache.setSession(root, new HashMap<String, Serializable>(), this.sessionTimeout);
            response.addCookie(this.createCookie(request, root));
        }
        request.setAttribute(CURRENT_SESSION_ID, (Object)root);
        return root;
    }

    @Override
    public void logout(HttpServletRequest request, HttpServletResponse response) {
        request.removeAttribute(CURRENT_SESSION);
        request.removeAttribute(CURRENT_SESSION_ID);
        String root = request.getRequestedSessionId();
        if (!StringUtils.isBlank((String)root)) {
            this.sessionCache.clear(root);
            Cookie cookie = this.createCookie(request, null);
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
    }

    private Cookie createCookie(HttpServletRequest request, String value) {
        Cookie cookie = new Cookie("JSESSIONID", value);
        String ctx = request.getContextPath();
        cookie.setPath(StringUtils.isBlank((String)ctx) ? "/" : ctx);
        return cookie;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.sessionCache);
        Assert.notNull((Object)this.sessionIdGenerator);
    }

    public void setSessionCache(SessionCache sessionCache) {
        this.sessionCache = sessionCache;
    }

    public void setSessionTimeout(int sessionTimeout) {
        Assert.isTrue((sessionTimeout > 0 ? 1 : 0) != 0);
        this.sessionTimeout = sessionTimeout;
    }

    public void setSessionIdGenerator(SessionIdGenerator sessionIdGenerator) {
        this.sessionIdGenerator = sessionIdGenerator;
    }
}

