/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.common.web.session.cache;

import com.jspgou.common.web.session.cache.SessionCache;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class EhcacheSessionCache
implements SessionCache,
InitializingBean {
    private Ehcache cache;

    @Override
    public Map<String, Serializable> getSession(String root) {
        Element e = this.cache.get((Serializable)((Object)root));
        return e != null ? (HashMap)e.getValue() : null;
    }

    @Override
    public void setSession(String root, Map<String, Serializable> session, int exp) {
        this.cache.put(new Element((Object)root, session));
    }

    @Override
    public Serializable getAttribute(String root, String name) {
        Map<String, Serializable> session = this.getSession(root);
        return session != null ? session.get(name) : null;
    }

    @Override
    public void setAttribute(String root, String name, Serializable value, int exp) {
        Map<String, Serializable> session = this.getSession(root);
        if (session == null) {
            session = new HashMap<String, Serializable>();
        }
        session.put(name, value);
        this.cache.put(new Element((Object)root, session));
    }

    @Override
    public void clear(String root) {
        this.cache.remove((Serializable)((Object)root));
    }

    @Override
    public boolean exist(String root) {
        return this.cache.isKeyInCache((Object)root);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cache);
    }

    public void setCache(Ehcache cache) {
        this.cache = cache;
    }
}

