/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.common.web.springmvc;

import com.jspgou.cms.web.threadvariable.MemberThread;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.view.AbstractTemplateView;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;

public class SimpleFreeMarkerView
extends AbstractTemplateView {
    public static final String CONTEXT_PATH = "base";
    public static final String SSO_ENABLE = "ssoEnable";
    public static final String USER = "user";
    private Configuration configuration;

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected FreeMarkerConfig autodetectConfiguration() throws BeansException {
        try {
            return (FreeMarkerConfig)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), FreeMarkerConfig.class, (boolean)true, (boolean)false);
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new ApplicationContextException("Must define a single FreeMarkerConfig bean in this web application context (may be inherited): FreeMarkerConfigurer is the usual implementation. This bean may be given any name.", (Throwable)ex);
        }
    }

    protected void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        if (this.getConfiguration() == null) {
            FreeMarkerConfig freemarkerconfig = this.autodetectConfiguration();
            this.setConfiguration(freemarkerconfig.getConfiguration());
        }
        this.checkTemplate();
    }

    protected void checkTemplate() throws ApplicationContextException {
        try {
            this.getConfiguration().getTemplate(this.getUrl());
        }
        catch (ParseException ex) {
            throw new ApplicationContextException("Failed to parse FreeMarker template for URL [" + this.getUrl() + "]", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new ApplicationContextException("Could not load FreeMarker template for URL [" + this.getUrl() + "]", (Throwable)ex);
        }
    }

    protected void renderMergedTemplateModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        model.put(CONTEXT_PATH, request.getContextPath());
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        model.put(SSO_ENABLE, web.getSsoEnable());
        model.put(USER, MemberThread.get());
        this.getConfiguration().getTemplate(this.getUrl()).process((Object)model, (Writer)response.getWriter());
    }
}

