
/*
*     MessageDigestV.cpp
*    MD5㷨ʵ
*    :Simple Source
*    :2006-3-2
*/
#include "StdAfx.h"
#include "md5.h"
namespace MD5
{
	CMessageDigestV::CMessageDigestV(void)
	{
	}
	CMessageDigestV::~CMessageDigestV(void)
	{
	}
	// fӺ = (x&y)|((~x)&z)
	inline UINT CMessageDigestV::Inner_f(UINT x, UINT y, UINT z)
	{
		return ((x & y) | (( ~x ) & z));
	}
	// gӺ = (x&z)|(y&(~z)) 
	inline UINT CMessageDigestV::Inner_g(UINT x, UINT y, UINT z)
	{
		return ((x & z) | (y & ( ~z )));
	}
	// hӺ = x^y^z 
	inline UINT CMessageDigestV::Inner_h(UINT x, UINT y, UINT z)
	{
		return (x ^ y ^ z);
	}
	// iӺ = y^(x|(~z))
	inline UINT CMessageDigestV::Inner_i(UINT x, UINT y, UINT z)
	{
		return (y ^ (x | ( ~z )));
	}
	// ѭλ
	inline UINT CMessageDigestV::Inner_RotateLeft(UINT x, UINT s)
	{
		return ((x << s) | (x >> (32 - s)));
	}
	// ffӺ
	inline void CMessageDigestV::Inner_ff(UINT &a, UINT b, UINT c, UINT d, UINT mj, UINT s, UINT ti)
	{
		a += this->Inner_f(b, c, d) + mj + ti;
		a = this->Inner_RotateLeft(a, s);
		a += b;
	}
	// ggӺ
	inline void CMessageDigestV::Inner_gg(UINT &a, UINT b, UINT c, UINT d, UINT mj, UINT s, UINT ti)
	{
		a += this->Inner_g(b, c, d) + mj + ti;
		a = this->Inner_RotateLeft(a, s);
		a += b;
	}
	// hhӺ
	inline void CMessageDigestV::Inner_hh(UINT &a, UINT b, UINT c, UINT d, UINT mj, UINT s, UINT ti)
	{
		a += this->Inner_h(b, c, d) + mj + ti;
		a = this->Inner_RotateLeft(a, s);
		a += b;
	}
	// iiӺ
	inline void CMessageDigestV::Inner_ii(UINT &a, UINT b, UINT c, UINT d, UINT mj, UINT s, UINT ti)
	{
		a += this->Inner_i(b, c, d) + mj + ti;
		a = this->Inner_RotateLeft(a, s);
		a += b;
	}
	// һ
	void CMessageDigestV::MakeOneTurn(UINT &a, UINT &b, UINT &c, UINT &d, UINT messageGroup[16])
	{
		this->Inner_ff(a, b, c, d, messageGroup[ 0],  7, 0xd76aa478);
		this->Inner_ff(d, a, b, c, messageGroup[ 1], 12, 0xe8c7b756);
		this->Inner_ff(c, d, a, b, messageGroup[ 2], 17, 0x242070db);
		this->Inner_ff(b, c, d, a, messageGroup[ 3], 22, 0xc1bdceee);
		this->Inner_ff(a, b, c, d, messageGroup[ 4],  7, 0xf57c0faf);
		this->Inner_ff(d, a, b, c, messageGroup[ 5], 12, 0x4787c62a);
		this->Inner_ff(c, d, a, b, messageGroup[ 6], 17, 0xa8304613);
		this->Inner_ff(b, c, d, a, messageGroup[ 7], 22, 0xfd469501);
		this->Inner_ff(a, b, c, d, messageGroup[ 8],  7, 0x698098d8);
		this->Inner_ff(d, a, b, c, messageGroup[ 9], 12, 0x8b44f7af);
		this->Inner_ff(c, d, a, b, messageGroup[10], 17, 0xffff5bb1);
		this->Inner_ff(b, c, d, a, messageGroup[11], 22, 0x895cd7be);
		this->Inner_ff(a, b, c, d, messageGroup[12],  7, 0x6b901122);
		this->Inner_ff(d, a, b, c, messageGroup[13], 12, 0xfd987193);
		this->Inner_ff(c, d, a, b, messageGroup[14], 17, 0xa679438e);
		this->Inner_ff(b, c, d, a, messageGroup[15], 22, 0x49b40821);
		this->Inner_gg(a, b, c, d, messageGroup[ 1],  5, 0xf61e2562);
		this->Inner_gg(d, a, b, c, messageGroup[ 6],  9, 0xc040b340);
		this->Inner_gg(c, d, a, b, messageGroup[11], 14, 0x265e5a51);
		this->Inner_gg(b, c, d, a, messageGroup[ 0], 20, 0xe9b6c7aa);
		this->Inner_gg(a, b, c, d, messageGroup[ 5],  5, 0xd62f105d);
		this->Inner_gg(d, a, b, c, messageGroup[10],  9, 0x02441453);
		this->Inner_gg(c, d, a, b, messageGroup[15], 14, 0xd8a1e681);
		this->Inner_gg(b, c, d, a, messageGroup[ 4], 20, 0xe7d3fbc8);
		this->Inner_gg(a, b, c, d, messageGroup[ 9],  5, 0x21e1cde6);
		this->Inner_gg(d, a, b, c, messageGroup[14],  9, 0xc33707d6);
		this->Inner_gg(c, d, a, b, messageGroup[ 3], 14, 0xf4d50d87);
		this->Inner_gg(b, c, d, a, messageGroup[ 8], 20, 0x455a14ed);
		this->Inner_gg(a, b, c, d, messageGroup[13],  5, 0xa9e3e905);
		this->Inner_gg(d, a, b, c, messageGroup[ 2],  9, 0xfcefa3f8);
		this->Inner_gg(c, d, a, b, messageGroup[ 7], 14, 0x676f02d9);
		this->Inner_gg(b, c, d, a, messageGroup[12], 20, 0x8d2a4c8a);
		this->Inner_hh(a, b, c, d, messageGroup[ 5],  4, 0xfffa3942);
		this->Inner_hh(d, a, b, c, messageGroup[ 8], 11, 0x8771f681);
		this->Inner_hh(c, d, a, b, messageGroup[11], 16, 0x6d9d6122);
		this->Inner_hh(b, c, d, a, messageGroup[14], 23, 0xfde5380c);
		this->Inner_hh(a, b, c, d, messageGroup[ 1],  4, 0xa4beea44);
		this->Inner_hh(d, a, b, c, messageGroup[ 4], 11, 0x4bdecfa9);
		this->Inner_hh(c, d, a, b, messageGroup[ 7], 16, 0xf6bb4b60);
		this->Inner_hh(b, c, d, a, messageGroup[10], 23, 0xbebfbc70);
		this->Inner_hh(a, b, c, d, messageGroup[13],  4, 0x289b7ec6);
		this->Inner_hh(d, a, b, c, messageGroup[ 0], 11, 0xeaa127fa);
		this->Inner_hh(c, d, a, b, messageGroup[ 3], 16, 0xd4ef3085);
		this->Inner_hh(b, c, d, a, messageGroup[ 6], 23, 0x04881d05);
		this->Inner_hh(a, b, c, d, messageGroup[ 9],  4, 0xd9d4d039);
		this->Inner_hh(d, a, b, c, messageGroup[12], 11, 0xe6db99e5);
		this->Inner_hh(c, d, a, b, messageGroup[15], 16, 0x1fa27cf8);
		this->Inner_hh(b, c, d, a, messageGroup[ 2], 23, 0xc4ac5665);
		this->Inner_ii(a, b, c, d, messageGroup[ 0],  6, 0xf4292244);
		this->Inner_ii(d, a, b, c, messageGroup[ 7], 10, 0x432aff97);
		this->Inner_ii(c, d, a, b, messageGroup[14], 15, 0xab9423a7);
		this->Inner_ii(b, c, d, a, messageGroup[ 5], 21, 0xfc93a039);
		this->Inner_ii(a, b, c, d, messageGroup[12],  6, 0x655b59c3);
		this->Inner_ii(d, a, b, c, messageGroup[ 3], 10, 0x8f0ccc92);
		this->Inner_ii(c, d, a, b, messageGroup[10], 15, 0xffeff47d);
		this->Inner_ii(b, c, d, a, messageGroup[ 1], 21, 0x85845dd1);
		this->Inner_ii(a, b, c, d, messageGroup[ 8],  6, 0x6fa87e4f);
		this->Inner_ii(d, a, b, c, messageGroup[15], 10, 0xfe2ce6e0);
		this->Inner_ii(c, d, a, b, messageGroup[ 6], 15, 0xa3014314);
		this->Inner_ii(b, c, d, a, messageGroup[13], 21, 0x4e0811a1);
		this->Inner_ii(a, b, c, d, messageGroup[ 4],  6, 0xf7537e82);
		this->Inner_ii(d, a, b, c, messageGroup[11], 10, 0xbd3af235);
		this->Inner_ii(c, d, a, b, messageGroup[ 2], 15, 0x2ad7d2bb);
		this->Inner_ii(b, c, d, a, messageGroup[ 9], 21, 0xeb86d391);
	}
	// ɢ
	void CMessageDigestV::Digest(const std::string& message,std::string &digest)
	{
		UINT len=message.length();
		UINT pointer = 0;
		UINT save[] = {0x67452301, 0xefcdab89, 0x98badcfe, 0x10325476};
		UINT a, b, c, d;
		char currentGroup[64];
		UINT groupLen;
		UINT i = 0;
		while(pointer <= len)
		{
			groupLen = len - pointer;
			if(groupLen > 64)
			{
				groupLen = 64;
			}
			for(i = 0; i < groupLen; i++)
			{
				currentGroup[i] = message[pointer + i];
			}
			pointer += groupLen;
			// 
			if(groupLen < 64)
			{
				if(groupLen > 0 || len == 0)
				{
					currentGroup[i] = (char)0x80;
					i++;
				}
				for(; i < 64; i++)
				{
					currentGroup[i] = 0;
				}
				if(groupLen < 56)
				{
					UINT blen = len * 8;
					char * p = (char *) & blen;
					for(i = 56; i < 60; i++)
					{
						currentGroup[i] = p[i - 56];
					}
					pointer = len + 1;
				}
			}
			a = save[0], b = save[1], c = save[2], d = save[3];
			this->MakeOneTurn(a, b, c, d, (UINT *)currentGroup);
			save[0] += a, save[1] += b, save[2] += c, save[3] += d;
		}
		/*for (int i=0;i<4;i++)
		{
			vecMD5Num.push_back(save[i]);
		}*/
		//CString digest = "";
		digest.clear();
		unsigned char * p = (unsigned char *)save;
		for(i = 0; i < 16; i++)
		{
			char c[20];
			wsprintfA(c,"%02x",p[i]);
			std::string a=std::string(c);
			digest=digest+a;
		}

	}
}


