/*
 * Decompiled with CFR 0.152.
 */
package cc.s2m.open_all_open.weixin;

import cc.s2m.util.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WxBasic {
    private static final Log LOGGER = LogFactory.getLog(WxBasic.class);

    public static String getToken(String appid, String secret) {
        JSONObject json;
        block6: {
            if (Strings.isNullOrEmpty((String)appid)) {
                return "";
            }
            if (Strings.isNullOrEmpty((String)secret)) {
                return "";
            }
            HashMap paramMap = Maps.newHashMap();
            paramMap.put("grant_type", "client_credential");
            paramMap.put("appid", appid);
            paramMap.put("secret", secret);
            String result = HttpUtil.get((String)"https://api.weixin.qq.com/cgi-bin/token", (Map)paramMap, null, (boolean)true);
            LOGGER.debug((Object)result);
            if (Strings.isNullOrEmpty((String)result)) {
                return "";
            }
            try {
                json = JSONObject.parseObject((String)result);
                if (json != null) break block6;
                return "";
            }
            catch (Exception e) {
                LOGGER.error((Object)"getToken", (Throwable)e);
                return result;
            }
        }
        return json.getString("access_token");
    }

    public static List<String> getServerIps(String accessToken) {
        if (Strings.isNullOrEmpty((String)accessToken)) {
            return Lists.newArrayList();
        }
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("access_token", accessToken);
        String result = HttpUtil.get((String)"https://api.weixin.qq.com/cgi-bin/getcallbackip", (Map)paramMap, null, (boolean)true);
        LOGGER.debug((Object)result);
        if (Strings.isNullOrEmpty((String)result)) {
            return Lists.newArrayList();
        }
        try {
            JSONObject json = JSONObject.parseObject((String)result);
            if (json == null) {
                return Lists.newArrayList();
            }
            JSONArray array = json.getJSONArray("ip_list");
            if (array == null) {
                return Lists.newArrayList();
            }
            Object[] ips = (String[])array.toArray((Object[])new String[0]);
            return Lists.newArrayList((Object[])ips);
        }
        catch (Exception e) {
            LOGGER.error((Object)"getServerIps", (Throwable)e);
            return Lists.newArrayList();
        }
    }
}

