/*
 * Decompiled with CFR 0.152.
 */
package cc.s2m.open_all_open.weixin;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WxRecieveMsg {
    private static final Log LOGGER = LogFactory.getLog(WxRecieveMsg.class);

    public static boolean checkIsReal(String accessToken, String signature, String timestamp, String nonce) {
        if (Strings.isNullOrEmpty((String)accessToken)) {
            return false;
        }
        if (Strings.isNullOrEmpty((String)signature)) {
            return false;
        }
        if (Strings.isNullOrEmpty((String)timestamp)) {
            return false;
        }
        if (Strings.isNullOrEmpty((String)nonce)) {
            return false;
        }
        LOGGER.debug((Object)("accessToken:" + accessToken + ",signature:" + signature + ",timestamp:" + timestamp + ",nonce:" + timestamp));
        ArrayList tmpArr = Lists.newArrayList((Object[])new String[]{accessToken, timestamp, nonce});
        Collections.sort(tmpArr);
        String newSign = DigestUtils.sha1Hex((String)(String.valueOf((String)tmpArr.get(0)) + (String)tmpArr.get(1) + (String)tmpArr.get(2)));
        LOGGER.debug((Object)("newSign:" + newSign));
        return newSign.equalsIgnoreCase(signature);
    }

    public static Map<String, String> getWeixinPushData(HttpServletRequest request) {
        HashMap reciveMap = Maps.newHashMap();
        try {
            Iterator iterator;
            Document document = new SAXReader().read((InputStream)request.getInputStream());
            if (document != null && (iterator = document.getRootElement().elementIterator()) != null) {
                while (iterator.hasNext()) {
                    Element node = (Element)iterator.next();
                    reciveMap.put(node.getName(), node.getTextTrim());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"getWeixinPushData", (Throwable)e);
        }
        LOGGER.debug((Object)reciveMap);
        return reciveMap;
    }
}

