/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.parser.state;

import com.itextpdf.tool.xml.parser.State;
import com.itextpdf.tool.xml.parser.XMLParser;

public class TagEncounteredState
implements State {
    private final XMLParser parser;

    public TagEncounteredState(XMLParser parser) {
        this.parser = parser;
    }

    public void process(char character) {
        String tag = this.parser.bufferToString();
        if (Character.isWhitespace(character) || character == '>' || character == '/' || character == ':' || character == '?' || tag.equals("!--") || tag.equals("![CDATA[")) {
            if (tag.length() > 0) {
                if (tag.equals("!--")) {
                    this.parser.flush();
                    this.parser.memory().comment().setLength(0);
                    this.parser.selectState().comment();
                    if (character != '-') {
                        this.parser.append(character);
                    } else {
                        this.parser.memory().comment().append(character);
                    }
                } else if (tag.equals("![CDATA[")) {
                    this.parser.flush();
                    this.parser.selectState().cdata();
                    this.parser.append(character);
                } else if (tag.equals("!DOCTYPE")) {
                    this.parser.flush();
                    this.parser.selectState().doctype();
                    this.parser.append(character);
                } else if (Character.isWhitespace(character)) {
                    this.parser.memory().currentTag(this.parser.bufferToString());
                    this.parser.flush();
                    this.parser.selectState().tagAttributes();
                } else if (character == '>') {
                    this.parser.memory().currentTag(tag);
                    this.parser.flush();
                    this.parser.startElement();
                    this.parser.selectState().inTag();
                } else if (character == '/') {
                    this.parser.memory().currentTag(tag);
                    this.parser.flush();
                    this.parser.selectState().selfClosing();
                } else if (character == ':') {
                    this.parser.memory().namespace(tag);
                    this.parser.flush();
                }
            } else if (character == '/') {
                this.parser.selectState().closingTag();
            } else if (character == '?') {
                this.parser.append(character);
                this.parser.selectState().processingInstructions();
            }
        } else {
            this.parser.append(character);
        }
    }
}

