/*
 * Decompiled with CFR 0.152.
 */
package cc.s2m.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieUtil {
    private HttpServletRequest request;
    private HttpServletResponse response;

    public CookieUtil(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public String getCookie(String name) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null && cookies.length > 0) {
            int i = 0;
            while (i < cookies.length) {
                Cookie cookie = cookies[i];
                if (cookie.getName().equals(name) && cookie.getValue() != null) {
                    try {
                        return URLDecoder.decode(cookie.getValue(), "utf-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public void removeCookie(String name, String domain) {
        this.setCookie(name, null, 0, domain);
    }

    public void setCookie(String name, String value, Integer maxAge, String domain) {
        Cookie c;
        Cookie[] cookies = this.request.getCookies();
        boolean flag = false;
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                c = cookieArray[n2];
                if (c.getName() != null && c.getName().equals(name)) {
                    try {
                        if (value != null) {
                            c.setValue(URLEncoder.encode(value, "utf-8"));
                        } else {
                            c.setValue(value);
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    if (domain != null && !"".equals(domain)) {
                        c.setDomain(domain);
                    }
                    c.setPath("/");
                    c.setMaxAge(maxAge.intValue());
                    this.response.addCookie(c);
                    flag = true;
                }
                ++n2;
            }
        }
        if (!flag) {
            try {
                c = value != null ? new Cookie(name, URLEncoder.encode(value, "utf-8")) : new Cookie(name, value);
                if (domain != null && !"".equals(domain)) {
                    c.setDomain(domain);
                }
                c.setPath("/");
                c.setMaxAge(maxAge.intValue());
                this.response.addCookie(c);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }
}

