/*
 * Decompiled with CFR 0.152.
 */
package cc.s2m.util;

import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    private static final Log LOGGER = LogFactory.getLog(HttpUtil.class);

    public static String get(String url, Map<String, Object> ParamMap, Map<String, String> headerParamMap, boolean isSSL) {
        try {
            if (ParamMap != null && ParamMap.size() > 0) {
                url = HttpUtil.formatGetParameter(url, ParamMap);
            }
            HttpGet get = new HttpGet(url);
            if (headerParamMap != null && headerParamMap.size() > 0) {
                for (String key : headerParamMap.keySet()) {
                    get.addHeader(key, headerParamMap.get(key));
                }
            }
            HttpClientBuilder create = HttpClientBuilder.create();
            CloseableHttpClient client = create.build();
            if (isSSL) {
                client = HttpUtil.createSSLClientDefault();
            }
            CloseableHttpResponse execute = client.execute((HttpUriRequest)get);
            String content = EntityUtils.toString((HttpEntity)execute.getEntity(), (String)"UTF-8");
            LOGGER.debug((Object)url);
            Charset charset = ContentType.getOrDefault((HttpEntity)execute.getEntity()).getCharset();
            LOGGER.debug((Object)charset);
            LOGGER.debug((Object)execute.getStatusLine().getStatusCode());
            LOGGER.debug((Object)content);
            try {
                execute.close();
                client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return content;
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            return null;
        }
    }

    public static String postMethodUrl(String url, String body, Map<String, Object> ParamMap, Map<String, String> headerParamMap, boolean isSSL) {
        try {
            HttpPost post = new HttpPost(url);
            if (headerParamMap != null && headerParamMap.size() > 0) {
                for (String key : headerParamMap.keySet()) {
                    post.addHeader(key, headerParamMap.get(key));
                }
            }
            if (ParamMap != null && ParamMap.size() > 0) {
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                for (String key : ParamMap.keySet()) {
                    nvps.add(new BasicNameValuePair(key, String.valueOf(ParamMap.get(key))));
                }
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
            }
            if (body != null && !"".equals(body)) {
                post.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
            }
            HttpClientBuilder create = HttpClientBuilder.create();
            CloseableHttpClient client = create.build();
            if (isSSL) {
                client = HttpUtil.createSSLClientDefault();
            }
            CloseableHttpResponse execute = client.execute((HttpUriRequest)post);
            String content = EntityUtils.toString((HttpEntity)execute.getEntity());
            LOGGER.debug((Object)url);
            Charset charset = ContentType.getOrDefault((HttpEntity)execute.getEntity()).getCharset();
            LOGGER.debug((Object)charset);
            LOGGER.debug((Object)execute.getStatusLine().getStatusCode());
            LOGGER.debug((Object)content);
            execute.close();
            client.close();
            return content;
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            return null;
        }
    }

    public static String formatGetParameter(String url, Map<String, Object> argsMap) {
        if (url != null && url.length() > 0) {
            if (!url.endsWith("?")) {
                url = String.valueOf(url) + "?";
            }
            if (argsMap != null && !argsMap.isEmpty()) {
                Set<Map.Entry<String, Object>> entrySet = argsMap.entrySet();
                Iterator<Map.Entry<String, Object>> iterator = entrySet.iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Object> entry = iterator.next();
                    if (entry == null) continue;
                    String key = entry.getKey();
                    String value = (String)entry.getValue();
                    url = String.valueOf(url) + key + "=" + value;
                    if (!iterator.hasNext()) continue;
                    url = String.valueOf(url) + "&";
                }
            }
        }
        return url;
    }

    public static CloseableHttpClient createSSLClientDefault() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        catch (KeyManagementException e) {
            LOGGER.error((Object)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)e);
        }
        catch (KeyStoreException e) {
            LOGGER.error((Object)e);
        }
        return HttpClients.createDefault();
    }
}

