/*
 * Decompiled with CFR 0.152.
 */
package cc.s2m.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageUtil {
    private static final Log log = LogFactory.getLog(ImageUtil.class);

    public static File reuceImgOnlyWidth(File srcfile, int widthdist) {
        try {
            String filedir = srcfile.getParent();
            String fileNameOld = srcfile.getAbsolutePath();
            String fileName = String.valueOf(System.currentTimeMillis()) + fileNameOld.substring(fileNameOld.lastIndexOf("."));
            File dir = new File(String.valueOf(filedir) + File.separator + widthdist);
            if (!dir.exists()) {
                dir.mkdir();
            }
            BufferedImage bi = ImageIO.read(srcfile);
            Double width = new Double(bi.getWidth());
            Double height = new Double(bi.getHeight());
            if (width < (double)widthdist) {
                BufferedImage tag = new BufferedImage(width.intValue(), height.intValue(), 1);
                tag.getGraphics().drawImage(bi.getScaledInstance(width.intValue(), height.intValue(), 4), 0, 0, null);
                FileOutputStream out = new FileOutputStream(String.valueOf(dir.getAbsolutePath()) + File.separator + fileName);
                ImageIO.write((RenderedImage)tag, "jpg", out);
                out.close();
                return new File(String.valueOf(dir.getAbsolutePath()) + File.separator + fileName);
            }
            Double heightdist = new Double(height / width * (double)widthdist);
            BufferedImage tag = new BufferedImage(widthdist, heightdist.intValue(), 1);
            tag.getGraphics().drawImage(bi.getScaledInstance(widthdist, heightdist.intValue(), 4), 0, 0, null);
            FileOutputStream out = new FileOutputStream(String.valueOf(dir.getAbsolutePath()) + File.separator + fileName);
            ImageIO.write((RenderedImage)tag, "jpg", out);
            out.close();
            return new File(String.valueOf(dir.getAbsolutePath()) + File.separator + fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            return null;
        }
    }

    public static String reuceImg(File srcfile, String parentPath, int widthdist) {
        try {
            String filedir = srcfile.getParent();
            String fileName = String.valueOf(System.currentTimeMillis()) + parentPath.substring(parentPath.lastIndexOf("."));
            File dir = new File(String.valueOf(filedir) + "/" + widthdist);
            if (!dir.exists()) {
                dir.mkdir();
            }
            BufferedImage bi = ImageIO.read(srcfile);
            Double width = new Double(bi.getWidth());
            Double height = new Double(bi.getHeight());
            if (width < height) {
                width = (double)widthdist * width / height;
                height = new Double(widthdist);
            }
            String path = null;
            if (width < (double)widthdist) {
                BufferedImage tag = new BufferedImage(width.intValue(), height.intValue(), 1);
                tag.getGraphics().drawImage(bi.getScaledInstance(width.intValue(), height.intValue(), 4), 0, 0, null);
                FileOutputStream out = new FileOutputStream(String.valueOf(dir.getAbsolutePath()) + "/" + fileName);
                ImageIO.write((RenderedImage)tag, "jpg", out);
                path = String.valueOf(parentPath.substring(0, parentPath.lastIndexOf("/"))) + "/" + widthdist + "/" + fileName;
                out.close();
            } else {
                Double heightdist = new Double(height / width * (double)widthdist);
                BufferedImage tag = new BufferedImage(widthdist, heightdist.intValue(), 1);
                tag.getGraphics().drawImage(bi.getScaledInstance(widthdist, heightdist.intValue(), 4), 0, 0, null);
                FileOutputStream out = new FileOutputStream(String.valueOf(dir.getAbsolutePath()) + "/" + fileName);
                ImageIO.write((RenderedImage)tag, "jpg", out);
                path = String.valueOf(parentPath.substring(0, parentPath.lastIndexOf("/"))) + "/" + widthdist + "/" + fileName;
                out.close();
            }
            return path;
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public static File reuceImgCutPart(File srcfile, int x, int y, int width, int height) {
        try {
            String filedir = srcfile.getParent();
            String fileNameOld = srcfile.getAbsolutePath();
            String fileName = String.valueOf(System.currentTimeMillis()) + fileNameOld.substring(fileNameOld.lastIndexOf("."));
            BufferedImage bi = ImageIO.read(srcfile);
            int a = bi.getWidth();
            int b = bi.getHeight();
            if (a < width + x) {
                width = a - x;
            }
            if (b < height + y) {
                height = b - y;
            }
            BufferedImage tag = bi.getSubimage(x, y, width, height);
            File dir = new File(String.valueOf(filedir) + File.separator + width + "_" + height);
            if (!dir.exists()) {
                dir.mkdir();
            }
            FileOutputStream out = new FileOutputStream(String.valueOf(dir.getAbsolutePath()) + "/" + fileName);
            ImageIO.write((RenderedImage)tag, "jpg", out);
            out.close();
            return new File(String.valueOf(dir.getAbsolutePath()) + File.separator + fileName);
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }
}

