/*
 * Decompiled with CFR 0.152.
 */
package cc.s2m.util;

import cc.s2m.util.Condition;
import cc.s2m.util.Page;
import com.google.common.collect.Lists;

public class PageUtil {
    private static final int DEF_PAGE_SIZE = 10;

    public static <T> Page<T> createPage(Page<T> page, int totalRow) {
        Lists.newArrayList();
        return PageUtil.createPage(page.getCondition(), page.getUrl(), page.getParam(), page.getPageSize(), page.getCurPage(), totalRow);
    }

    public static <T> Page<T> createPage(Condition condition, String url, String param, int pageSize, int curPage, int totalRow) {
        pageSize = PageUtil.getpageSize(pageSize);
        curPage = PageUtil.getcurPage(curPage);
        int beginIndex = PageUtil.getBeginIndex(pageSize, curPage);
        int totalPage = PageUtil.getTotalPage(pageSize, totalRow);
        boolean hasNextPage = PageUtil.hasNextPage(curPage, totalPage);
        boolean hasPrePage = PageUtil.hasPrePage(curPage);
        Page page = new Page(hasPrePage, hasNextPage, pageSize, totalPage, totalRow, curPage, beginIndex, condition, url);
        page.setParam(param);
        return page;
    }

    private static int getpageSize(int pageSize) {
        return pageSize == 0 ? 10 : pageSize;
    }

    private static int getcurPage(int curPage) {
        return curPage == 0 ? 1 : curPage;
    }

    private static int getBeginIndex(int pageSize, int curPage) {
        return (curPage - 1) * pageSize;
    }

    private static int getTotalPage(int pageSize, int totalRow) {
        int totalPage = 0;
        totalPage = totalRow % pageSize == 0 ? totalRow / pageSize : totalRow / pageSize + 1;
        return totalPage;
    }

    private static boolean hasPrePage(int curPage) {
        return curPage != 1;
    }

    private static boolean hasNextPage(int curPage, int totalPage) {
        return curPage != totalPage && totalPage != 0;
    }
}

