/*
 * Decompiled with CFR 0.152.
 */
package cc.s2m.util;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PinyinConv {
    private static final Log log = LogFactory.getLog(PinyinConv.class);

    public static String replaceSameChars(String chines) {
        if (chines == null) {
            chines = "";
        }
        chines = chines.replaceAll(",", "");
        chines = chines.replaceAll("\uff0c", "");
        chines = chines.replaceAll("\\.", "");
        chines = chines.replaceAll("\u3002", "");
        chines = chines.replaceAll("\u3001", "");
        return chines;
    }

    public static String converterToFirstSpell(String chines) {
        chines = PinyinConv.replaceSameChars(chines);
        String pinyinName = "";
        char[] nameChar = chines.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        int i = 0;
        while (i < nameChar.length) {
            if (nameChar[i] > '\u0080') {
                try {
                    pinyinName = String.valueOf(pinyinName) + PinyinHelper.toHanyuPinyinStringArray((char)nameChar[i], (HanyuPinyinOutputFormat)defaultFormat)[0].charAt(0);
                }
                catch (Exception e) {
                    log.error((Object)("\u5728\u8f6c\u6362\u6c49\u5b57<" + chines + ">\u6210\u62fc\u97f3\u65f6\u51fa\u9519\uff01"));
                }
            } else {
                pinyinName = String.valueOf(pinyinName) + nameChar[i];
            }
            ++i;
        }
        return pinyinName;
    }

    public static String converterToSpell(String chines) {
        chines = PinyinConv.replaceSameChars(chines);
        String pinyinName = "";
        char[] nameChar = chines.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        int i = 0;
        while (i < nameChar.length) {
            if (nameChar[i] > '\u0080') {
                try {
                    pinyinName = String.valueOf(pinyinName) + PinyinHelper.toHanyuPinyinStringArray((char)nameChar[i], (HanyuPinyinOutputFormat)defaultFormat)[0];
                }
                catch (Exception e) {
                    log.error((Object)("\u5728\u8f6c\u6362\u6c49\u5b57<" + chines + ">\u6210\u62fc\u97f3\u65f6\u51fa\u9519\uff01"));
                }
            } else {
                pinyinName = String.valueOf(pinyinName) + nameChar[i];
            }
            ++i;
        }
        return pinyinName;
    }
}

