/*
 * Decompiled with CFR 0.152.
 */
package cc.s2m.util.idsquence;

import cc.s2m.util.IDGenerator;
import cc.s2m.util.idsquence.SequenceRange;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;

public final class SequenceUtils {
    private static final Lock lock = new ReentrantLock();
    private static ConcurrentMap<String, SequenceRange> sequenceRangeMap = new ConcurrentHashMap<String, SequenceRange>();
    private static DataSource dataSource;

    public static void setDataSource(DataSource dataSource) {
        SequenceUtils.dataSource = dataSource;
    }

    public static long nextValue(String name) throws SQLException {
        long value;
        if (dataSource == null) {
            throw new RuntimeException("dataSource is null,Please set SequenceUtils.setDataSource(DataSource dataSource) value!");
        }
        if (!sequenceRangeMap.containsKey(name)) {
            lock.lock();
            try {
                sequenceRangeMap.putIfAbsent(name, SequenceUtils.nextRange(name));
            }
            finally {
                lock.unlock();
            }
        }
        if ((value = ((SequenceRange)sequenceRangeMap.get(name)).getAndIncrement()) == -1L) {
            lock.lock();
            try {
                while (true) {
                    if (((SequenceRange)sequenceRangeMap.get(name)).isOverflow()) {
                        sequenceRangeMap.replace(name, SequenceUtils.nextRange(name));
                    }
                    if ((value = ((SequenceRange)sequenceRangeMap.get(name)).getAndIncrement()) == -1L) {
                        continue;
                    }
                    break;
                }
            }
            finally {
                lock.unlock();
            }
        }
        return value;
    }

    public static SequenceRange nextRange(String name) throws SQLException {
        if (name == null) {
            throw new IllegalArgumentException("Sequence name is required");
        }
        int retryTimes = 32;
        int step = IDGenerator.getOrderIdStep();
        int i = 0;
        while (i < retryTimes) {
            Connection conn = dataSource.getConnection();
            conn.setAutoCommit(true);
            PreparedStatement ps = conn.prepareStatement("SELECT value FROM idCreater WHERE name = ?");
            ps.setString(1, name);
            ResultSet rs = ps.executeQuery();
            long oldValue = 0L;
            if (!rs.next()) {
                rs.close();
                ps.close();
                conn.close();
                throw new RuntimeException("Sequence name can not find, name = " + name);
            }
            oldValue = rs.getLong("value");
            rs.close();
            ps.close();
            if (oldValue < 0L || oldValue > 0x6FFFFFFFFFFFFFFFL) {
                conn.close();
                throw new RuntimeException("Sequence value is incorrect, value = " + oldValue);
            }
            long newValue = oldValue + (long)step;
            ps = conn.prepareStatement("update idCreater set value = ?,updatedAt=now() where name=? and value=?");
            ps.setLong(1, newValue);
            ps.setString(2, name);
            ps.setLong(3, oldValue);
            int efectRows = ps.executeUpdate();
            ps.close();
            conn.close();
            if (efectRows != 0) {
                return new SequenceRange(oldValue + 1L, newValue);
            }
            ++i;
        }
        throw new RuntimeException("Retried too many times, retryTimes = " + retryTimes);
    }

    private SequenceUtils() {
    }
}

