/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5;

import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContentType {
    private String baseType = "";
    private String subType = "";
    private final Map<String, String> parameters = CollectionFactory.newCaseInsensitiveMap();

    public ContentType() {
    }

    public ContentType(String contentType) {
        this.parse(contentType);
    }

    public ContentType(String contentType, String charset) {
        this(contentType);
        this.setParameter("charset", charset);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        ContentType ct = (ContentType)o;
        return this.baseType.equals(ct.baseType) && this.subType.equals(ct.subType) && ((Object)this.parameters).equals(ct.parameters);
    }

    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        assert (baseType != null);
        this.baseType = baseType;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        assert (subType != null);
        this.subType = subType;
    }

    public String getMimeType() {
        return this.baseType + "/" + this.subType;
    }

    public List<String> getParameterNames() {
        return InternalUtils.sortedKeys(this.parameters);
    }

    public String getCharset() {
        return this.getParameter("charset");
    }

    public String getParameter(String key) {
        assert (key != null);
        return this.parameters.get(key);
    }

    public void setParameter(String key, String value) {
        assert (key != null);
        assert (value != null);
        this.parameters.put(key, value);
    }

    public void parse(String contentType) {
        this.baseType = "";
        this.subType = "";
        this.parameters.clear();
        StringTokenizer tokens = new StringTokenizer(contentType, ";");
        if (!tokens.hasMoreTokens()) {
            return;
        }
        String mimeType = tokens.nextToken();
        StringTokenizer mimeTokens = new StringTokenizer(mimeType, "/");
        this.setBaseType(mimeTokens.hasMoreTokens() ? mimeTokens.nextToken() : "");
        this.setSubType(mimeTokens.hasMoreTokens() ? mimeTokens.nextToken() : "");
        while (tokens.hasMoreTokens()) {
            String parameter = tokens.nextToken();
            StringTokenizer parameterTokens = new StringTokenizer(parameter, "=");
            String key = parameterTokens.hasMoreTokens() ? parameterTokens.nextToken() : "";
            String value = parameterTokens.hasMoreTokens() ? parameterTokens.nextToken() : "";
            this.setParameter(key, value);
        }
    }

    public String unparse() {
        StringBuilder buffer = new StringBuilder(this.getMimeType());
        for (String parameterName : this.getParameterNames()) {
            buffer.append(";");
            buffer.append(parameterName);
            buffer.append("=");
            buffer.append(this.parameters.get(parameterName));
        }
        return buffer.toString();
    }

    public String toString() {
        return this.unparse();
    }
}

