/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.util.Collections;
import java.util.Iterator;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentAction;
import org.apache.tapestry5.ComponentEventCallback;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.Renderable;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.corelib.components.FormFragment;
import org.apache.tapestry5.corelib.internal.AjaxFormLoopContext;
import org.apache.tapestry5.internal.services.PageRenderQueue;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.ComponentDefaultProvider;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.Heartbeat;
import org.apache.tapestry5.services.PartialMarkupRenderer;
import org.apache.tapestry5.services.PartialMarkupRendererFilter;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

public class AjaxFormLoop {
    @Parameter(defaultPrefix="literal")
    @Property(write=false)
    private String element;
    @Parameter(required=true, autoconnect=true)
    private Iterable source;
    @Parameter(required=true)
    private Object value;
    @Parameter(defaultPrefix="literal")
    private String show;
    @Parameter
    private Object[] context;
    @Parameter(value="block:defaultAddRow", defaultPrefix="literal")
    @Property(write=false)
    private Block addRow;
    @Inject
    private Block tail;
    @Parameter(required=true, allowNull=false)
    private ValueEncoder<Object> encoder;
    @InjectComponent
    private ClientElement rowInjector;
    @InjectComponent
    private FormFragment fragment;
    @Inject
    private Block ajaxResponse;
    @Inject
    private ComponentResources resources;
    @Environmental
    private FormSupport formSupport;
    @Environmental
    private Heartbeat heartbeat;
    @Inject
    private Environment environment;
    @Inject
    private JavaScriptSupport jsSupport;
    private JSONArray addRowTriggers;
    private Iterator iterator;
    @Inject
    private TypeCoercer typeCoercer;
    @Inject
    private ComponentDefaultProvider defaultProvider;
    @Inject
    private PageRenderQueue pageRenderQueue;
    private boolean renderingInjector;
    private final AjaxFormLoopContext formLoopContext = new AjaxFormLoopContext(){

        public void addAddRowTrigger(String clientId) {
            assert (InternalUtils.isNonBlank((String)clientId));
            AjaxFormLoop.this.addRowTriggers.put((Object)clientId);
        }

        private String currentFragmentId() {
            ClientElement element = AjaxFormLoop.this.renderingInjector ? AjaxFormLoop.this.rowInjector : AjaxFormLoop.this.fragment;
            return element.getClientId();
        }

        public void addRemoveRowTrigger(String clientId) {
            Link link = AjaxFormLoop.this.resources.createEventLink("triggerRemoveRow", AjaxFormLoop.this.toClientValue());
            String asURI = link.toURI();
            JSONObject spec = new JSONObject();
            spec.put("link", (Object)clientId);
            spec.put("fragment", (Object)this.currentFragmentId());
            spec.put("url", (Object)asURI);
            AjaxFormLoop.this.jsSupport.addInitializerCall("formLoopRemoveLink", spec);
        }
    };
    private static final ComponentAction<AjaxFormLoop> BEGIN_HEARTBEAT = new ComponentAction<AjaxFormLoop>(){

        @Override
        public void execute(AjaxFormLoop component) {
            component.beginHeartbeat();
        }

        public String toString() {
            return "AjaxFormLoop.BeginHeartbeat";
        }
    };
    @Property(write=false)
    private final Renderable beginHeartbeat = new Renderable(){

        public void render(MarkupWriter writer) {
            AjaxFormLoop.this.formSupport.storeAndExecute(AjaxFormLoop.this, BEGIN_HEARTBEAT);
        }
    };
    private static final ComponentAction<AjaxFormLoop> END_HEARTBEAT = new ComponentAction<AjaxFormLoop>(){

        @Override
        public void execute(AjaxFormLoop component) {
            component.endHeartbeat();
        }

        public String toString() {
            return "AjaxFormLoop.EndHeartbeat";
        }
    };
    @Property(write=false)
    private final Renderable endHeartbeat = new Renderable(){

        public void render(MarkupWriter writer) {
            AjaxFormLoop.this.formSupport.storeAndExecute(AjaxFormLoop.this, END_HEARTBEAT);
        }
    };
    @Property(write=false)
    private final Renderable beforeBody = new Renderable(){

        public void render(MarkupWriter writer) {
            AjaxFormLoop.this.beginHeartbeat();
            AjaxFormLoop.this.syncCurrentValue();
        }
    };
    @Property(write=false)
    private final Renderable afterBody = new Renderable(){

        public void render(MarkupWriter writer) {
            AjaxFormLoop.this.endHeartbeat();
        }
    };
    @Property(write=false)
    private final Renderable syncValue = new Renderable(){

        public void render(MarkupWriter writer) {
            AjaxFormLoop.this.syncCurrentValue();
        }
    };

    ValueEncoder defaultEncoder() {
        return this.defaultProvider.defaultValueEncoder("value", this.resources);
    }

    String defaultElement() {
        return this.resources.getElementName("div");
    }

    @Log
    private void syncValue(String clientValue) {
        Object value = this.encoder.toValue(clientValue);
        if (value == null) {
            throw new RuntimeException(String.format("Unable to convert client value '%s' back into a server-side object.", clientValue));
        }
        this.value = value;
    }

    private void syncCurrentValue() {
        String id = this.toClientValue();
        this.formSupport.store(this, new SyncValue(id));
    }

    private String toClientValue() {
        return this.encoder.toClient(this.value);
    }

    void setupRender() {
        this.addRowTriggers = new JSONArray();
        this.pushContext();
        this.iterator = this.source == null ? Collections.EMPTY_LIST.iterator() : this.source.iterator();
        this.renderingInjector = false;
    }

    private void pushContext() {
        this.environment.push(AjaxFormLoopContext.class, this.formLoopContext);
    }

    boolean beginRender(MarkupWriter writer) {
        if (!this.iterator.hasNext()) {
            return false;
        }
        this.value = this.iterator.next();
        return true;
    }

    Object afterRender(MarkupWriter writer) {
        if (!this.iterator.hasNext()) {
            this.renderingInjector = true;
            return this.tail;
        }
        return false;
    }

    void cleanupRender() {
        this.popContext();
        JSONObject spec = new JSONObject();
        spec.put("rowInjector", (Object)this.rowInjector.getClientId());
        spec.put("addRowTriggers", (Object)this.addRowTriggers);
        this.jsSupport.addInitializerCall("ajaxFormLoop", spec);
    }

    private void popContext() {
        this.environment.pop(AjaxFormLoopContext.class);
    }

    @Log
    Object onActionFromRowInjector(EventContext context) {
        ComponentEventCallback callback = new ComponentEventCallback(){

            public boolean handleResult(Object result) {
                AjaxFormLoop.this.value = result;
                return true;
            }
        };
        this.resources.triggerContextEvent("addRow", context, callback);
        if (this.value == null) {
            throw new IllegalArgumentException(String.format("Event handler for event 'addRow' from %s should have returned a non-null value.", this.resources.getCompleteId()));
        }
        this.renderingInjector = true;
        this.pageRenderQueue.addPartialMarkupRendererFilter(new PartialMarkupRendererFilter(){

            public void renderMarkup(MarkupWriter writer, JSONObject reply, PartialMarkupRenderer renderer) {
                AjaxFormLoop.this.pushContext();
                renderer.renderMarkup(writer, reply);
                AjaxFormLoop.this.popContext();
            }
        });
        return this.ajaxResponse;
    }

    @Log
    Object onTriggerRemoveRow(String rowId) {
        Object value = this.encoder.toValue(rowId);
        this.resources.triggerEvent("removeRow", new Object[]{value}, null);
        return new JSONObject();
    }

    private void beginHeartbeat() {
        this.heartbeat.begin();
    }

    private void endHeartbeat() {
        this.heartbeat.end();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SyncValue
    implements ComponentAction<AjaxFormLoop> {
        private final String clientValue;

        public SyncValue(String clientValue) {
            this.clientValue = clientValue;
        }

        @Override
        public void execute(AjaxFormLoop component) {
            component.syncValue(this.clientValue);
        }

        public String toString() {
            return String.format("AjaxFormLoop.SyncValue[%s]", this.clientValue);
        }
    }
}

