/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.FieldValidationSupport;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.OptionGroupModel;
import org.apache.tapestry5.OptionModel;
import org.apache.tapestry5.Renderable;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.SelectModelVisitor;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.ValidationTracker;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.corelib.base.AbstractField;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.services.ComponentDefaultProvider;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Checklist
extends AbstractField {
    @Parameter(required=true)
    private SelectModel model;
    @Parameter(required=true, autoconnect=true)
    private List<Object> selected;
    @Parameter(required=true, allowNull=false)
    private ValueEncoder<Object> encoder;
    @Parameter(defaultPrefix="validate")
    private FieldValidator<Object> validate;
    @Inject
    private Request request;
    @Inject
    private FieldValidationSupport fieldValidationSupport;
    @Environmental
    private ValidationTracker tracker;
    @Inject
    private ComponentResources componentResources;
    @Inject
    private ComponentDefaultProvider defaultProvider;
    @Inject
    private JavaScriptSupport javaScriptSupport;
    @Property
    private List<Renderable> availableOptions;
    private MarkupWriter markupWriter;

    void setupRender(MarkupWriter writer) {
        this.markupWriter = writer;
        this.availableOptions = CollectionFactory.newList();
        SelectModelVisitor visitor = new SelectModelVisitor(){

            public void beginOptionGroup(OptionGroupModel groupModel) {
            }

            public void option(OptionModel optionModel) {
                Checklist.this.availableOptions.add(new RenderRadio(optionModel));
            }

            public void endOptionGroup(OptionGroupModel groupModel) {
            }
        };
        this.model.visit(visitor);
    }

    @Override
    protected void processSubmission(String controlName) {
        String[] parameters = this.request.getParameters(controlName);
        List selected = this.selected;
        if (selected == null) {
            selected = CollectionFactory.newList();
        } else {
            selected.clear();
        }
        if (parameters != null) {
            for (String value : parameters) {
                Object objectValue = this.encoder.toValue(value);
                selected.add(objectValue);
            }
        }
        this.putPropertyNameIntoBeanValidationContext("selected");
        try {
            this.fieldValidationSupport.validate(selected, this.componentResources, this.validate);
            this.selected = selected;
        }
        catch (ValidationException e) {
            this.tracker.recordError(this, e.getMessage());
        }
        this.removePropertyNameFromBeanValidationContext();
    }

    Set<Object> getSelected() {
        if (this.selected == null) {
            return Collections.emptySet();
        }
        return CollectionFactory.newSet(this.selected);
    }

    Binding defaultValidate() {
        return this.defaultProvider.defaultValidatorBinding("selected", this.componentResources);
    }

    @Override
    public boolean isRequired() {
        return this.validate.isRequired();
    }

    private final class RenderRadio
    implements Renderable {
        private final OptionModel model;

        private RenderRadio(OptionModel model) {
            this.model = model;
        }

        public void render(MarkupWriter writer) {
            String clientId = Checklist.this.javaScriptSupport.allocateClientId(Checklist.this.componentResources);
            String clientValue = Checklist.this.encoder.toClient(this.model.getValue());
            Element checkbox = writer.element("input", "type", "checkbox", "id", clientId, "name", Checklist.this.getControlName(), "value", clientValue);
            if (Checklist.this.getSelected().contains(this.model.getValue())) {
                checkbox.attribute("checked", "checked");
            }
            writer.end();
            writer.element("label", "for", clientId);
            writer.write(this.model.getLabel());
            writer.end();
        }
    }
}

