/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.FieldValidationSupport;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.ValidationTracker;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.RequestParameter;
import org.apache.tapestry5.corelib.base.AbstractField;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.ComponentDefaultProvider;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@Import(stack={"core-datefield"})
public class DateField
extends AbstractField {
    @Parameter(required=true, principal=true, autoconnect=true)
    private Date value;
    @Parameter(required=true, allowNull=false, defaultPrefix="literal")
    private DateFormat format;
    @Parameter
    private boolean hideTextField;
    @Parameter(defaultPrefix="validate")
    private FieldValidator<Object> validate;
    @Parameter(defaultPrefix="asset", value="datefield.gif")
    private Asset icon;
    @Parameter(value="componentResources.messages")
    private Messages messages;
    @Environmental
    private JavaScriptSupport support;
    @Environmental
    private ValidationTracker tracker;
    @Inject
    private ComponentResources resources;
    @Inject
    private Request request;
    @Inject
    private Locale locale;
    @Inject
    private ComponentDefaultProvider defaultProvider;
    @Inject
    private FieldValidationSupport fieldValidationSupport;
    private static final String RESULT = "result";
    private static final String ERROR = "error";
    private static final String INPUT_PARAMETER = "input";

    DateFormat defaultFormat() {
        DateFormat shortDateFormat = DateFormat.getDateInstance(3, this.locale);
        if (shortDateFormat instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)shortDateFormat;
            String pattern = simpleDateFormat.toPattern();
            String revised = pattern.replaceAll("([^y])yy$", "$1yyyy");
            return new SimpleDateFormat(revised);
        }
        return shortDateFormat;
    }

    final Binding defaultValidate() {
        return this.defaultProvider.defaultValidatorBinding("value", this.resources);
    }

    JSONObject onParse(@RequestParameter(value="input") String input) {
        JSONObject response = new JSONObject();
        try {
            Date date = this.format.parse(input);
            response.put(RESULT, (Object)date.getTime());
        }
        catch (ParseException ex) {
            response.put(ERROR, (Object)ex.getMessage());
        }
        return response;
    }

    JSONObject onFormat(@RequestParameter(value="input") String input) {
        JSONObject response = new JSONObject();
        try {
            long millis = Long.parseLong(input);
            Date date = new Date(millis);
            response.put(RESULT, (Object)this.format.format(date));
        }
        catch (NumberFormatException ex) {
            response.put(ERROR, (Object)ex.getMessage());
        }
        return response;
    }

    void beginRender(MarkupWriter writer) {
        String value = this.tracker.getInput(this);
        if (value == null) {
            value = this.formatCurrentValue();
        }
        String clientId = this.getClientId();
        String triggerId = clientId + "-trigger";
        writer.element(INPUT_PARAMETER, "type", this.hideTextField ? "hidden" : "text", "name", this.getControlName(), "id", clientId, "value", value);
        this.writeDisabled(writer);
        this.putPropertyNameIntoBeanValidationContext("value");
        this.validate.render(writer);
        this.removePropertyNameFromBeanValidationContext();
        this.resources.renderInformalParameters(writer);
        this.decorateInsideField();
        writer.end();
        writer.element("img", "id", triggerId, "class", "t-calendar-trigger", "src", this.icon.toClientURL(), "alt", "[Show]");
        writer.end();
        JSONObject spec = new JSONObject();
        spec.put("field", (Object)clientId);
        spec.put("parseURL", (Object)this.resources.createEventLink("parse", new Object[0]).toURI());
        spec.put("formatURL", (Object)this.resources.createEventLink("format", new Object[0]).toURI());
        this.support.addInitializerCall("dateField", spec);
    }

    private void writeDisabled(MarkupWriter writer) {
        if (this.isDisabled()) {
            writer.attributes("disabled", "disabled");
        }
    }

    private String formatCurrentValue() {
        if (this.value == null) {
            return "";
        }
        return this.format.format(this.value);
    }

    protected void processSubmission(String controlName) {
        String value = this.request.getParameter(controlName);
        this.tracker.recordInput(this, value);
        Date parsedValue = null;
        try {
            if (InternalUtils.isNonBlank((String)value)) {
                parsedValue = this.format.parse(value);
            }
        }
        catch (ParseException ex) {
            this.tracker.recordError(this, this.messages.format("date-value-not-parseable", new Object[]{value}));
            return;
        }
        this.putPropertyNameIntoBeanValidationContext("value");
        try {
            this.fieldValidationSupport.validate(parsedValue, this.resources, this.validate);
            this.value = parsedValue;
        }
        catch (ValidationException ex) {
            this.tracker.recordError(this, ex.getMessage());
        }
        this.removePropertyNameFromBeanValidationContext();
    }

    void injectResources(ComponentResources resources) {
        this.resources = resources;
    }

    public boolean isRequired() {
        return this.validate.isRequired();
    }
}

