/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.util.List;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationTracker;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.corelib.internal.InternalMessages;

public class Errors {
    @Parameter(value="message:default-banner")
    private String banner;
    @Parameter(name="class")
    private String className = "t-error";
    @Environmental(value=false)
    private ValidationTracker tracker;

    void beginRender(MarkupWriter writer) {
        if (this.tracker == null) {
            throw new RuntimeException(InternalMessages.encloseErrorsInForm());
        }
        if (!this.tracker.getHasErrors()) {
            return;
        }
        writer.element("div", "class", this.className);
        writer.element("div", "class", "t-banner");
        writer.write(this.banner);
        writer.end();
        List<String> errors = this.tracker.getErrors();
        if (!errors.isEmpty()) {
            writer.element("ul", new Object[0]);
            for (String message : errors) {
                writer.element("li", new Object[0]);
                writer.write(message);
                writer.end();
            }
            writer.end();
        }
        writer.end();
    }
}

