/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.io.IOException;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.TrackableComponentEventCallback;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.corelib.data.InsertPosition;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.ClientBehaviorSupport;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.ajax.AjaxResponseRenderer;
import org.apache.tapestry5.services.ajax.JSONCallback;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@SupportsInformalParameters
public class FormInjector
implements ClientElement {
    public static final String INJECT_EVENT = "inject";
    @Parameter
    private Object[] context;
    @Parameter(defaultPrefix="literal", value="symbol:tapestry.components.forminjector_insert_position")
    private InsertPosition position;
    @Parameter(defaultPrefix="literal", value="symbol:tapestry.components.forminjector_show_function")
    private String show;
    @Parameter(defaultPrefix="literal")
    private String element;
    @Environmental
    private JavaScriptSupport javascriptSupport;
    @Environmental
    private FormSupport formSupport;
    @Environmental
    private ClientBehaviorSupport clientBehaviorSupport;
    @Environmental
    private TrackableComponentEventCallback eventCallback;
    private String clientId;
    @Inject
    private ComponentResources resources;
    @Inject
    private AjaxResponseRenderer ajaxResponseRenderer;
    private Element clientElement;

    String defaultElement() {
        return this.resources.getElementName("div");
    }

    void beginRender(MarkupWriter writer) {
        this.clientId = this.javascriptSupport.allocateClientId(this.resources);
        this.clientElement = writer.element(this.element, "id", this.clientId);
        this.resources.renderInformalParameters(writer);
        Link link = this.resources.createEventLink(INJECT_EVENT, this.context);
        link.addParameter("t:formid", this.formSupport.getClientId());
        link.addParameter("t:formcomponentid", this.formSupport.getFormComponentId());
        this.clientBehaviorSupport.addFormInjector(this.clientId, link, this.position, this.show);
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
        this.clientElement.addClassName("t-forminjector");
    }

    public String getClientId() {
        return this.clientId;
    }

    void onInject(EventContext context) throws IOException {
        this.ajaxResponseRenderer.addCallback(new JSONCallback(){

            public void run(JSONObject reply) {
                FormInjector.this.clientId = FormInjector.this.javascriptSupport.allocateClientId(FormInjector.this.resources);
                reply.put("elementId", (Object)FormInjector.this.clientId);
            }
        });
        this.resources.triggerContextEvent("action", context, this.eventCallback);
    }
}

