/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import org.apache.tapestry5.ComponentAction;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.FieldValidationSupport;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.RadioContainer;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.ValidationTracker;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.ComponentDefaultProvider;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.Request;

public class RadioGroup
implements Field {
    @Parameter(required=true, principal=true, autoconnect=true)
    private Object value;
    @Parameter(value="false")
    private boolean disabled;
    @Parameter(defaultPrefix="literal")
    private String label;
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter(required=true, allowNull=false)
    private ValueEncoder encoder;
    @Parameter(defaultPrefix="validate")
    private FieldValidator<Object> validate;
    @Inject
    private ComponentDefaultProvider defaultProvider;
    @Inject
    private ComponentResources resources;
    @Environmental
    private FormSupport formSupport;
    @Inject
    private Environment environment;
    @Inject
    private Request request;
    @Environmental
    private ValidationTracker tracker;
    @Inject
    private FieldValidationSupport fieldValidationSupport;
    private String controlName;
    private static final ComponentAction<RadioGroup> PROCESS_SUBMISSION = new ComponentAction<RadioGroup>(){
        private static final long serialVersionUID = -3857110108918776386L;

        @Override
        public void execute(RadioGroup component) {
            component.processSubmission();
        }

        public String toString() {
            return "RadioGroup.ProcessSubmission";
        }
    };

    String defaultLabel() {
        return this.defaultProvider.defaultLabel(this.resources);
    }

    final ValueEncoder defaultEncoder() {
        return this.defaultProvider.defaultValueEncoder("value", this.resources);
    }

    private void setup(String elementName) {
        this.controlName = elementName;
    }

    private void processSubmission() {
        String rawValue = this.request.getParameter(this.controlName);
        this.tracker.recordInput(this, rawValue);
        try {
            if (this.validate != null) {
                this.fieldValidationSupport.validate(rawValue, this.resources, this.validate);
            }
        }
        catch (ValidationException ex) {
            this.tracker.recordError(this, ex.getMessage());
        }
        this.value = this.encoder.toValue(rawValue);
    }

    final void setupRender() {
        Setup action = new Setup(this.formSupport.allocateControlName(this.clientId));
        this.formSupport.storeAndExecute(this, action);
        String submittedValue = this.tracker.getInput(this);
        final String selectedValue = submittedValue != null ? submittedValue : this.encoder.toClient(this.value);
        this.environment.push(RadioContainer.class, new RadioContainer(){

            public String getControlName() {
                return RadioGroup.this.controlName;
            }

            public boolean isDisabled() {
                return RadioGroup.this.disabled;
            }

            public String toClient(Object value) {
                return RadioGroup.this.encoder.toClient(value);
            }

            public boolean isSelected(Object value) {
                return TapestryInternalUtils.isEqual(RadioGroup.this.encoder.toClient(value), selectedValue);
            }
        });
        this.formSupport.store(this, PROCESS_SUBMISSION);
    }

    final void afterRender() {
        this.environment.pop(RadioContainer.class);
    }

    public String getControlName() {
        return this.controlName;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String getClientId() {
        return null;
    }

    public boolean isRequired() {
        return this.validate.isRequired();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Setup
    implements ComponentAction<RadioGroup> {
        private static final long serialVersionUID = -7984673040135949374L;
        private final String controlName;

        Setup(String controlName) {
            this.controlName = controlName;
        }

        @Override
        public void execute(RadioGroup component) {
            component.setup(this.controlName);
        }

        public String toString() {
            return String.format("RadioGroup.Setup[%s]", this.controlName);
        }
    }
}

