/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import org.apache.tapestry5.Binding;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.FieldValidationSupport;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.OptionModel;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.ValidationTracker;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.annotations.BeforeRenderTemplate;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Mixin;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.RequestParameter;
import org.apache.tapestry5.corelib.base.AbstractField;
import org.apache.tapestry5.corelib.data.BlankOption;
import org.apache.tapestry5.corelib.mixins.RenderDisabled;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.util.CaptureResultCallback;
import org.apache.tapestry5.internal.util.SelectModelRenderer;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.ComponentDefaultProvider;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.util.EnumSelectModel;

public class Select
extends AbstractField {
    public static final String CHANGE_EVENT = "change";
    @Parameter
    private ValueEncoder encoder;
    @Inject
    private ComponentDefaultProvider defaultProvider;
    @Parameter(required=true, allowNull=false)
    private SelectModel model;
    @Parameter(value="auto", defaultPrefix="literal")
    private BlankOption blankOption;
    @Parameter(defaultPrefix="literal")
    private String blankLabel;
    @Inject
    private Request request;
    @Inject
    private ComponentResources resources;
    @Environmental
    private ValidationTracker tracker;
    @Parameter(defaultPrefix="validate")
    private FieldValidator<Object> validate;
    @Parameter(required=true, principal=true, autoconnect=true)
    private Object value;
    @Parameter(defaultPrefix="literal")
    private String zone;
    @Inject
    private FieldValidationSupport fieldValidationSupport;
    @Environmental
    private FormSupport formSupport;
    @Inject
    private JavaScriptSupport javascriptSupport;
    @Mixin
    private RenderDisabled renderDisabled;
    private String selectedClientValue;

    private boolean isSelected(String clientValue) {
        return TapestryInternalUtils.isEqual(clientValue, this.selectedClientValue);
    }

    protected void processSubmission(String controlName) {
        String submittedValue = this.request.getParameter(controlName);
        this.tracker.recordInput(this, submittedValue);
        Object selectedValue = this.toValue(submittedValue);
        this.putPropertyNameIntoBeanValidationContext("value");
        try {
            this.fieldValidationSupport.validate(selectedValue, this.resources, this.validate);
            this.value = selectedValue;
        }
        catch (ValidationException ex) {
            this.tracker.recordError(this, ex.getMessage());
        }
        this.removePropertyNameFromBeanValidationContext();
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
    }

    void beginRender(MarkupWriter writer) {
        writer.element("select", "name", this.getControlName(), "id", this.getClientId());
        this.putPropertyNameIntoBeanValidationContext("value");
        this.validate.render(writer);
        this.removePropertyNameFromBeanValidationContext();
        this.resources.renderInformalParameters(writer);
        this.decorateInsideField();
        if (this.zone != null) {
            Link link = this.resources.createEventLink(CHANGE_EVENT, new Object[0]);
            JSONObject spec = new JSONObject(new String[]{"selectId", this.getClientId(), "zoneId", this.zone, "url", link.toURI()});
            this.javascriptSupport.addInitializerCall("linkSelectToZone", spec);
        }
    }

    Object onChange(@RequestParameter(value="t:selectvalue", allowBlank=true) String selectValue) {
        Object newValue = this.toValue(selectValue);
        CaptureResultCallback callback = new CaptureResultCallback();
        this.resources.triggerEvent("valueChanged", new Object[]{newValue}, callback);
        this.value = newValue;
        return callback.getResult();
    }

    protected Object toValue(String submittedValue) {
        return InternalUtils.isBlank((String)submittedValue) ? null : this.encoder.toValue(submittedValue);
    }

    ValueEncoder defaultEncoder() {
        return this.defaultProvider.defaultValueEncoder("value", this.resources);
    }

    SelectModel defaultModel() {
        Class valueType = this.resources.getBoundType("value");
        if (valueType == null) {
            return null;
        }
        if (Enum.class.isAssignableFrom(valueType)) {
            return new EnumSelectModel(valueType, this.resources.getContainerMessages());
        }
        return null;
    }

    Binding defaultValidate() {
        return this.defaultProvider.defaultValidatorBinding("value", this.resources);
    }

    Object defaultBlankLabel() {
        String key;
        Messages containerMessages = this.resources.getContainerMessages();
        if (containerMessages.contains(key = this.resources.getId() + "-blanklabel")) {
            return containerMessages.get(key);
        }
        return null;
    }

    @BeforeRenderTemplate
    void options(MarkupWriter writer) {
        this.selectedClientValue = this.tracker.getInput(this);
        if (this.selectedClientValue == null) {
            String string = this.selectedClientValue = this.value == null ? null : this.encoder.toClient(this.value);
        }
        if (this.showBlankOption()) {
            writer.element("option", "value", "");
            writer.write(this.blankLabel);
            writer.end();
        }
        Renderer renderer = new Renderer(writer);
        this.model.visit(renderer);
    }

    public boolean isRequired() {
        return this.validate.isRequired();
    }

    private boolean showBlankOption() {
        switch (this.blankOption) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
        }
        return !this.isRequired();
    }

    void setModel(SelectModel model) {
        this.model = model;
        this.blankOption = BlankOption.NEVER;
    }

    void setValue(Object value) {
        this.value = value;
    }

    void setValueEncoder(ValueEncoder encoder) {
        this.encoder = encoder;
    }

    void setValidationTracker(ValidationTracker tracker) {
        this.tracker = tracker;
    }

    void setBlankOption(BlankOption option, String label) {
        this.blankOption = option;
        this.blankLabel = label;
    }

    private class Renderer
    extends SelectModelRenderer {
        public Renderer(MarkupWriter writer) {
            super(writer, Select.this.encoder);
        }

        protected boolean isOptionSelected(OptionModel optionModel, String clientValue) {
            return Select.this.isSelected(clientValue);
        }
    }
}

