/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.internal;

import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.tapestry5.ComponentAction;
import org.apache.tapestry5.corelib.internal.InternalMessages;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.services.ClientDataEncoder;
import org.apache.tapestry5.services.ClientDataSink;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentActionSink {
    private final Logger logger;
    private final ObjectOutputStream stream;
    private final ClientDataSink sink;
    private boolean empty = true;

    public ComponentActionSink(Logger logger, ClientDataEncoder encoder) {
        this.logger = logger;
        this.sink = encoder.createSink();
        this.stream = this.sink.getObjectOutputStream();
    }

    public <T> void store(T component, ComponentAction<T> action) {
        Component castComponent = (Component)component;
        assert (action != null);
        String completeId = castComponent.getComponentResources().getCompleteId();
        this.logger.debug("Storing action: {} {}", (Object)completeId, action);
        try {
            this.stream.writeUTF(completeId);
            this.stream.writeObject(action);
        }
        catch (IOException ex) {
            throw new RuntimeException(InternalMessages.componentActionNotSerializable(completeId, ex), ex);
        }
        this.empty = false;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public String getClientData() {
        return this.sink.getClientData();
    }
}

