/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.Asset2;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.OptionModel;
import org.apache.tapestry5.PropertyConduit;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.internal.IOOperation;
import org.apache.tapestry5.internal.InternalConstants;
import org.apache.tapestry5.internal.InternalMessages;
import org.apache.tapestry5.internal.InternalPropertyConduit;
import org.apache.tapestry5.internal.KeyValue;
import org.apache.tapestry5.internal.OptionModelImpl;
import org.apache.tapestry5.internal.SelectModelImpl;
import org.apache.tapestry5.internal.util.Holder;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.Orderable;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.LinkCreationListener;
import org.apache.tapestry5.services.LinkCreationListener2;
import org.apache.tapestry5.services.PageRenderRequestParameters;
import org.apache.tapestry5.services.javascript.StylesheetLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TapestryInternalUtils {
    private static final String SLASH = "/";
    private static final Pattern SLASH_PATTERN = Pattern.compile("/");
    private static final Pattern NON_WORD_PATTERN = Pattern.compile("[^\\w]");
    private static final Pattern COMMA_PATTERN = Pattern.compile("\\s*,\\s*");
    private static final int BUFFER_SIZE = 5000;
    public static Mapper<Asset, StylesheetLink> assetToStylesheetLink = new Mapper<Asset, StylesheetLink>(){

        public StylesheetLink map(Asset input) {
            return new StylesheetLink(input);
        }
    };

    public static String toUserPresentable(String id) {
        StringBuilder builder = new StringBuilder(id.length() * 2);
        char[] chars = id.toCharArray();
        boolean postSpace = true;
        boolean upcaseNext = true;
        for (char ch : chars) {
            if (upcaseNext) {
                builder.append(Character.toUpperCase(ch));
                upcaseNext = false;
                continue;
            }
            if (ch == '_') {
                builder.append(' ');
                upcaseNext = true;
                continue;
            }
            boolean upperCase = Character.isUpperCase(ch);
            if (upperCase && !postSpace) {
                builder.append(' ');
            }
            builder.append(ch);
            postSpace = upperCase;
        }
        return builder.toString();
    }

    public static Map<String, String> mapFromKeysAndValues(String ... keysAndValues) {
        Map result = CollectionFactory.newMap();
        int i = 0;
        while (i < keysAndValues.length) {
            String key = keysAndValues[i++];
            String value = keysAndValues[i++];
            result.put(key, value);
        }
        return result;
    }

    public static OptionModel toOptionModel(String input) {
        assert (input != null);
        int equalsx = input.indexOf(61);
        if (equalsx < 0) {
            return new OptionModelImpl(input);
        }
        String value = input.substring(0, equalsx);
        String label = input.substring(equalsx + 1);
        return new OptionModelImpl(label, value);
    }

    public static List<OptionModel> toOptionModels(String input) {
        assert (input != null);
        List result = CollectionFactory.newList();
        for (String term : input.split(",")) {
            result.add(TapestryInternalUtils.toOptionModel(term.trim()));
        }
        return result;
    }

    public static SelectModel toSelectModel(String input) {
        List<OptionModel> options = TapestryInternalUtils.toOptionModels(input);
        return new SelectModelImpl(null, options);
    }

    public static OptionModel toOptionModel(Map.Entry input) {
        assert (input != null);
        String label = input.getValue() != null ? String.valueOf(input.getValue()) : "";
        return new OptionModelImpl(label, input.getKey());
    }

    public static <K, V> List<OptionModel> toOptionModels(Map<K, V> input) {
        assert (input != null);
        List result = CollectionFactory.newList();
        for (Map.Entry<K, V> entry : input.entrySet()) {
            result.add(TapestryInternalUtils.toOptionModel(entry));
        }
        return result;
    }

    public static <K, V> SelectModel toSelectModel(Map<K, V> input) {
        List<OptionModel> options = TapestryInternalUtils.toOptionModels(input);
        return new SelectModelImpl(null, options);
    }

    public static OptionModel toOptionModel(Object input) {
        String label = input != null ? String.valueOf(input) : "";
        return new OptionModelImpl(label, input);
    }

    public static <E> List<OptionModel> toOptionModels(List<E> input) {
        assert (input != null);
        List result = CollectionFactory.newList();
        for (E element : input) {
            result.add(TapestryInternalUtils.toOptionModel(element));
        }
        return result;
    }

    public static <E> SelectModel toSelectModel(List<E> input) {
        List<OptionModel> options = TapestryInternalUtils.toOptionModels(input);
        return new SelectModelImpl(null, options);
    }

    public static KeyValue parseKeyValue(String input) {
        int pos = input.indexOf(61);
        if (pos < 1) {
            throw new IllegalArgumentException(InternalMessages.badKeyValue(input));
        }
        String key = input.substring(0, pos);
        String value = input.substring(pos + 1);
        return new KeyValue(key.trim(), value.trim());
    }

    public static String extractIdFromPropertyExpression(String expression) {
        return TapestryInternalUtils.replace(expression, NON_WORD_PATTERN, "");
    }

    public static String defaultLabel(String id, Messages messages, String propertyExpression) {
        String key = id + "-label";
        if (messages.contains(key)) {
            return messages.get(key);
        }
        return TapestryInternalUtils.toUserPresentable(TapestryInternalUtils.extractIdFromPropertyExpression(TapestryInternalUtils.lastTerm(propertyExpression)));
    }

    public static String lastTerm(String input) {
        int dotx = input.lastIndexOf(46);
        return input.substring(dotx + 1);
    }

    public static String toClassAttributeValue(List<String> classes) {
        if (classes.isEmpty()) {
            return null;
        }
        return InternalUtils.join(classes, (String)" ");
    }

    public static String getLabelForEnum(Messages messages, String prefix, Enum value) {
        String name = value.name();
        String key = prefix + "." + name;
        if (messages.contains(key)) {
            return messages.get(key);
        }
        if (messages.contains(name)) {
            return messages.get(name);
        }
        return TapestryInternalUtils.toUserPresentable(name.toLowerCase());
    }

    public static String getLabelForEnum(Messages messages, Enum value) {
        String prefix = TapestryInternalUtils.lastTerm(value.getClass().getName());
        return TapestryInternalUtils.getLabelForEnum(messages, prefix, value);
    }

    private static String replace(String input, Pattern pattern, String replacement) {
        return pattern.matcher(input).replaceAll(replacement);
    }

    public static <T> boolean isEqual(T left, T right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        return left.equals(right);
    }

    public static String[] splitPath(String path) {
        return SLASH_PATTERN.split(path);
    }

    public static String[] splitAtCommas(String value) {
        if (InternalUtils.isBlank((String)value)) {
            return InternalConstants.EMPTY_STRING_ARRAY;
        }
        return COMMA_PATTERN.split(value.trim());
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int length;
        byte[] buffer = new byte[5000];
        while ((length = in.read(buffer)) >= 0) {
            out.write(buffer, 0, length);
        }
        out.flush();
    }

    public static boolean isEqual(EventContext left, EventContext right) {
        if (left == right) {
            return true;
        }
        int count = left.getCount();
        if (count != right.getCount()) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            if (left.get(Object.class, i).equals(right.get(Object.class, i))) continue;
            return false;
        }
        return true;
    }

    public static Asset2 toAsset2(final Asset asset) {
        if (asset instanceof Asset2) {
            return (Asset2)asset;
        }
        return new Asset2(){

            public boolean isInvariant() {
                return false;
            }

            public Resource getResource() {
                return asset.getResource();
            }

            public String toClientURL() {
                return asset.toClientURL();
            }

            public String toString() {
                return asset.toString();
            }
        };
    }

    public static InternalPropertyConduit toInternalPropertyConduit(final PropertyConduit conduit) {
        if (conduit instanceof InternalPropertyConduit) {
            return (InternalPropertyConduit)conduit;
        }
        return new InternalPropertyConduit(){

            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return (T)conduit.getAnnotation(annotationClass);
            }

            @Override
            public void set(Object instance, Object value) {
                conduit.set(instance, value);
            }

            @Override
            public Class getPropertyType() {
                return conduit.getPropertyType();
            }

            @Override
            public Object get(Object instance) {
                return conduit.get(instance);
            }

            @Override
            public String getPropertyName() {
                return null;
            }
        };
    }

    public static Orderable<String> mixinTypeAndOrder(String mixinDef) {
        int idx = mixinDef.indexOf("::");
        if (idx == -1) {
            return new Orderable(mixinDef, (Object)mixinDef, new String[0]);
        }
        String type = mixinDef.substring(0, idx);
        String[] constraints = TapestryInternalUtils.splitMixinConstraints(mixinDef.substring(idx + 2));
        return new Orderable(type, (Object)type, constraints);
    }

    public static String[] splitMixinConstraints(String s) {
        return InternalUtils.isBlank((String)s) ? null : s.split(";");
    }

    public static LinkCreationListener2 toLinkCreationListener2(final LinkCreationListener delegate) {
        return new LinkCreationListener2(){

            public void createdPageRenderLink(Link link, PageRenderRequestParameters parameters) {
                delegate.createdPageRenderLink(link);
            }

            public void createdComponentEventLink(Link link, ComponentEventRequestParameters parameters) {
                delegate.createdComponentEventLink(link);
            }
        };
    }

    public static String toFileSuffix(String fileName) {
        int dotx = fileName.lastIndexOf(46);
        return dotx < 0 ? "" : fileName.substring(dotx + 1);
    }

    public static void performIO(OperationTracker tracker, String description, final IOOperation operation) throws IOException {
        final Holder exceptionHolder = Holder.create();
        tracker.run(description, new Runnable(){

            public void run() {
                try {
                    operation.perform();
                }
                catch (IOException ex) {
                    exceptionHolder.put(ex);
                }
            }
        });
        if (exceptionHolder.hasValue()) {
            throw (IOException)exceptionHolder.get();
        }
    }

    public static <K, V> V getAndDeref(Map<K, ? extends Reference<V>> map, K key) {
        Reference<V> ref = map.get(key);
        return ref == null ? null : (V)ref.get();
    }
}

