/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.beaneditor;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.PropertyConduit;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.beaneditor.PropertyModel;
import org.apache.tapestry5.beaneditor.RelativePosition;
import org.apache.tapestry5.internal.beaneditor.PropertyModelImpl;
import org.apache.tapestry5.internal.services.CoercingPropertyConduitWrapper;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.ioc.util.AvailableValues;
import org.apache.tapestry5.ioc.util.UnknownValueException;
import org.apache.tapestry5.plastic.PlasticUtils;
import org.apache.tapestry5.services.PropertyConduitSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanModelImpl<T>
implements BeanModel<T> {
    private final Class<T> beanType;
    private final PropertyConduitSource propertyConduitSource;
    private final TypeCoercer typeCoercer;
    private final Messages messages;
    private final ObjectLocator locator;
    private final Map<String, PropertyModel> properties = CollectionFactory.newCaseInsensitiveMap();
    private final List<String> propertyNames = CollectionFactory.newList();
    private static PropertyConduit NULL_PROPERTY_CONDUIT = null;

    public BeanModelImpl(Class<T> beanType, PropertyConduitSource propertyConduitSource, TypeCoercer typeCoercer, Messages messages, ObjectLocator locator) {
        this.beanType = beanType;
        this.propertyConduitSource = propertyConduitSource;
        this.typeCoercer = typeCoercer;
        this.messages = messages;
        this.locator = locator;
    }

    @Override
    public Class<T> getBeanType() {
        return this.beanType;
    }

    @Override
    public T newInstance() {
        return (T)this.locator.autobuild("Instantiating new instance of " + this.beanType.getName(), this.beanType);
    }

    @Override
    public PropertyModel add(String propertyName) {
        return this.addExpression(propertyName, propertyName);
    }

    @Override
    public PropertyModel addEmpty(String propertyName) {
        return this.add(propertyName, NULL_PROPERTY_CONDUIT);
    }

    @Override
    public PropertyModel addExpression(String propertyName, String expression) {
        CoercingPropertyConduitWrapper conduit = this.createConduit(expression);
        return this.add(propertyName, conduit);
    }

    private void validateNewPropertyName(String propertyName) {
        assert (InternalUtils.isNonBlank((String)propertyName));
        if (this.properties.containsKey(propertyName)) {
            throw new RuntimeException(String.format("Bean editor model for %s already contains a property model for property '%s'.", this.beanType.getName(), propertyName));
        }
    }

    @Override
    public PropertyModel add(RelativePosition position, String existingPropertyName, String propertyName, PropertyConduit conduit) {
        assert (position != null);
        this.validateNewPropertyName(propertyName);
        PropertyModel existing = this.get(existingPropertyName);
        int pos = this.propertyNames.indexOf(existing.getPropertyName());
        PropertyModelImpl newModel = new PropertyModelImpl(this, propertyName, conduit, this.messages);
        this.properties.put(propertyName, newModel);
        int offset = position == RelativePosition.AFTER ? 1 : 0;
        this.propertyNames.add(pos + offset, propertyName);
        return newModel;
    }

    @Override
    public PropertyModel add(RelativePosition position, String existingPropertyName, String propertyName) {
        CoercingPropertyConduitWrapper conduit = this.createConduit(propertyName);
        return this.add(position, existingPropertyName, propertyName, conduit);
    }

    @Override
    public PropertyModel add(String propertyName, PropertyConduit conduit) {
        this.validateNewPropertyName(propertyName);
        PropertyModelImpl propertyModel = new PropertyModelImpl(this, propertyName, conduit, this.messages);
        this.properties.put(propertyName, propertyModel);
        this.propertyNames.add(propertyName);
        return propertyModel;
    }

    private CoercingPropertyConduitWrapper createConduit(String propertyName) {
        return new CoercingPropertyConduitWrapper(this.propertyConduitSource.create(this.beanType, propertyName), this.typeCoercer);
    }

    @Override
    public PropertyModel get(String propertyName) {
        PropertyModel propertyModel = this.properties.get(propertyName);
        if (propertyModel == null) {
            throw new UnknownValueException(String.format("Bean editor model for %s does not contain a property named '%s'.", this.beanType.getName(), propertyName), new AvailableValues("Defined properties", this.propertyNames));
        }
        return propertyModel;
    }

    @Override
    public PropertyModel getById(String propertyId) {
        for (PropertyModel model : this.properties.values()) {
            if (!model.getId().equalsIgnoreCase(propertyId)) continue;
            return model;
        }
        List ids = CollectionFactory.newList();
        for (PropertyModel model : this.properties.values()) {
            ids.add(model.getId());
        }
        throw new UnknownValueException(String.format("Bean editor model for %s does not contain a property with id '%s'.", this.beanType.getName(), propertyId), new AvailableValues("Defined property ids", (Collection)ids));
    }

    @Override
    public List<String> getPropertyNames() {
        return CollectionFactory.newList(this.propertyNames);
    }

    @Override
    public BeanModel<T> exclude(String ... propertyNames) {
        for (String propertyName : propertyNames) {
            PropertyModel model = this.properties.get(propertyName);
            if (model == null) continue;
            this.propertyNames.remove(model.getPropertyName());
            this.properties.remove(propertyName);
        }
        return this;
    }

    @Override
    public BeanModel<T> reorder(String ... propertyNames) {
        List remainingPropertyNames = CollectionFactory.newList(this.propertyNames);
        List reorderedPropertyNames = CollectionFactory.newList();
        for (String name : propertyNames) {
            PropertyModel model = this.get(name);
            String canonical = model.getPropertyName();
            reorderedPropertyNames.add(canonical);
            remainingPropertyNames.remove(canonical);
        }
        this.propertyNames.clear();
        this.propertyNames.addAll(reorderedPropertyNames);
        this.propertyNames.addAll(remainingPropertyNames);
        return this;
    }

    @Override
    public BeanModel<T> include(String ... propertyNames) {
        List reorderedPropertyNames = CollectionFactory.newList();
        Map reduced = CollectionFactory.newCaseInsensitiveMap();
        for (String name : propertyNames) {
            PropertyModel model = this.get(name);
            String canonical = model.getPropertyName();
            reorderedPropertyNames.add(canonical);
            reduced.put(canonical, model);
        }
        this.propertyNames.clear();
        this.propertyNames.addAll(reorderedPropertyNames);
        this.properties.clear();
        this.properties.putAll(reduced);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BeanModel[");
        builder.append(PlasticUtils.toTypeName(this.beanType));
        builder.append(" properties:");
        String sep = "";
        for (String name : this.propertyNames) {
            builder.append(sep);
            builder.append(name);
            sep = ", ";
        }
        builder.append("]");
        return builder.toString();
    }
}

