/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.pageload;

import java.util.List;
import java.util.Map;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.internal.pageload.ComponentAssembler;
import org.apache.tapestry5.internal.pageload.ComponentAssemblerSource;
import org.apache.tapestry5.internal.pageload.ComponentName;
import org.apache.tapestry5.internal.pageload.EmbeddedComponentAssembler;
import org.apache.tapestry5.internal.pageload.EmbeddedComponentAssemblerImpl;
import org.apache.tapestry5.internal.pageload.PageAssembly;
import org.apache.tapestry5.internal.pageload.PageAssemblyAction;
import org.apache.tapestry5.internal.pageload.PageloadMessages;
import org.apache.tapestry5.internal.pageload.ParameterBinder;
import org.apache.tapestry5.internal.services.ComponentInstantiatorSource;
import org.apache.tapestry5.internal.services.Instantiator;
import org.apache.tapestry5.internal.structure.BodyPageElement;
import org.apache.tapestry5.internal.structure.ComponentPageElement;
import org.apache.tapestry5.internal.structure.ComponentPageElementImpl;
import org.apache.tapestry5.internal.structure.ComponentPageElementResources;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.TapestryException;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.apache.tapestry5.ioc.util.IdAllocator;
import org.apache.tapestry5.model.ComponentModel;
import org.apache.tapestry5.model.EmbeddedComponentModel;
import org.apache.tapestry5.runtime.RenderCommand;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.pageload.ComponentResourceSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComponentAssemblerImpl
implements ComponentAssembler {
    private final ComponentAssemblerSource assemblerSource;
    private final ComponentInstantiatorSource instantiatorSource;
    private final ComponentClassResolver componentClassResolver;
    private final Instantiator instantiator;
    private final ComponentPageElementResources resources;
    private final List<PageAssemblyAction> actions = CollectionFactory.newList();
    private final IdAllocator allocator = new IdAllocator();
    private final OperationTracker tracker;
    private final Request request;
    private final SymbolSource symbolSource;
    private Map<String, String> publishedParameterToEmbeddedId;
    private Map<String, EmbeddedComponentAssembler> embeddedIdToAssembler;

    public ComponentAssemblerImpl(ComponentAssemblerSource assemblerSource, ComponentInstantiatorSource instantiatorSource, ComponentClassResolver componentClassResolver, Instantiator instantiator, ComponentPageElementResources resources, OperationTracker tracker, Request request, SymbolSource symbolSource) {
        this.assemblerSource = assemblerSource;
        this.instantiatorSource = instantiatorSource;
        this.componentClassResolver = componentClassResolver;
        this.instantiator = instantiator;
        this.resources = resources;
        this.tracker = tracker;
        this.request = request;
        this.symbolSource = symbolSource;
    }

    @Override
    public ComponentPageElement assembleRootComponent(final Page page) {
        return (ComponentPageElement)this.tracker.invoke("Assembling root component for page " + page.getName(), (Invokable)new Invokable<ComponentPageElement>(){

            public ComponentPageElement invoke() {
                return ComponentAssemblerImpl.this.performAssembleRootComponent(page);
            }
        });
    }

    private ComponentPageElement performAssembleRootComponent(Page page) {
        PageAssembly pageAssembly = new PageAssembly(page);
        long startTime = System.currentTimeMillis();
        try {
            ++pageAssembly.componentCount;
            ++pageAssembly.weight;
            ComponentPageElementImpl newElement = new ComponentPageElementImpl(pageAssembly.page, this.instantiator, this.resources, this.request, this.symbolSource);
            pageAssembly.componentName.push((Object)new ComponentName(pageAssembly.page.getName()));
            this.addRootComponentMixins(pageAssembly, newElement);
            this.pushNewElement(pageAssembly, newElement);
            this.runActions(pageAssembly);
            this.popNewElement(pageAssembly);
            int count = pageAssembly.deferred.size();
            for (int i = count - 1; i >= 0; --i) {
                PageAssemblyAction action = pageAssembly.deferred.get(i);
                ++pageAssembly.weight;
                action.execute(pageAssembly);
            }
            page.setStats(new Page.Stats(System.currentTimeMillis() - startTime, pageAssembly.componentCount, pageAssembly.weight));
            return (ComponentPageElement)pageAssembly.createdElement.peek();
        }
        catch (RuntimeException ex) {
            throw new RuntimeException(PageloadMessages.exceptionAssemblingRootComponent(pageAssembly.page.getName(), InternalUtils.toMessage((Throwable)ex)), ex);
        }
    }

    private void addRootComponentMixins(PageAssembly assembly, ComponentPageElement element) {
        for (String className : this.instantiator.getModel().getMixinClassNames()) {
            ++assembly.weight;
            Instantiator mixinInstantiator = this.instantiatorSource.getInstantiator(className);
            ComponentModel model = this.instantiator.getModel();
            element.addMixin(InternalUtils.lastTerm((String)className), mixinInstantiator, model.getOrderForMixin(className));
        }
    }

    @Override
    public void assembleEmbeddedComponent(final PageAssembly pageAssembly, final EmbeddedComponentAssembler embeddedAssembler, final String embeddedId, final String elementName, final Location location) {
        ComponentName containerName = (ComponentName)pageAssembly.componentName.peek();
        final ComponentName embeddedName = containerName.child(embeddedId.toLowerCase());
        final String componentClassName = this.instantiator.getModel().getComponentClassName();
        String description = String.format("Assembling component %s (%s)", embeddedName.completeId, componentClassName);
        this.tracker.run(description, new Runnable(){

            public void run() {
                ComponentPageElement container = (ComponentPageElement)pageAssembly.activeElement.peek();
                try {
                    pageAssembly.componentName.push((Object)embeddedName);
                    ComponentPageElement newElement = container.newChild(embeddedId, embeddedName.nestedId, embeddedName.completeId, elementName, ComponentAssemblerImpl.this.instantiator, location);
                    ++pageAssembly.componentCount;
                    ++pageAssembly.weight;
                    ComponentAssemblerImpl.this.pushNewElement(pageAssembly, newElement);
                    int mixinCount = embeddedAssembler.addMixinsToElement(newElement);
                    pageAssembly.weight += mixinCount;
                    ComponentAssemblerImpl.this.runActions(pageAssembly);
                    ComponentAssemblerImpl.this.popNewElement(pageAssembly);
                    pageAssembly.componentName.pop();
                }
                catch (RuntimeException ex) {
                    throw new TapestryException(PageloadMessages.exceptionAssemblingEmbeddedComponent(embeddedId, componentClassName, container.getCompleteId(), InternalUtils.toMessage((Throwable)ex)), location, (Throwable)ex);
                }
            }
        });
    }

    private void pushNewElement(PageAssembly pageAssembly, final ComponentPageElement componentElement) {
        pageAssembly.activeElement.push((Object)componentElement);
        pageAssembly.createdElement.push((Object)componentElement);
        BodyPageElement shunt = new BodyPageElement(){

            public void addToBody(RenderCommand element) {
                componentElement.addToTemplate(element);
            }
        };
        pageAssembly.bodyElement.push((Object)shunt);
    }

    private void popNewElement(PageAssembly pageAssembly) {
        pageAssembly.bodyElement.pop();
        pageAssembly.activeElement.pop();
    }

    private void runActions(PageAssembly pageAssembly) {
        for (PageAssemblyAction action : this.actions) {
            ++pageAssembly.weight;
            action.execute(pageAssembly);
        }
    }

    @Override
    public ComponentModel getModel() {
        return this.instantiator.getModel();
    }

    @Override
    public void add(PageAssemblyAction action) {
        this.actions.add(action);
    }

    @Override
    public void validateEmbeddedIds(Map<String, Location> componentIds, Resource templateResource) {
        Map embeddedIds = CollectionFactory.newCaseInsensitiveMap();
        for (String id : this.getModel().getEmbeddedComponentIds()) {
            embeddedIds.put(id, true);
        }
        for (String id : componentIds.keySet()) {
            this.allocator.allocateId(id);
            embeddedIds.remove(id);
        }
        if (!embeddedIds.isEmpty()) {
            String className = this.getModel().getComponentClassName();
            throw new RuntimeException(PageloadMessages.embeddedComponentsNotInTemplate(InternalUtils.joinSorted(embeddedIds.keySet()), className, InternalUtils.lastTerm((String)className), templateResource));
        }
    }

    @Override
    public String generateEmbeddedId(String componentType) {
        int slashx = componentType.lastIndexOf("/");
        String baseId = componentType.substring(slashx + 1).toLowerCase();
        return this.allocator.allocateId(baseId);
    }

    @Override
    public EmbeddedComponentAssembler createEmbeddedAssembler(String embeddedId, String componentClassName, EmbeddedComponentModel embeddedModel, String mixins, Location location) {
        try {
            if (InternalUtils.isBlank((String)componentClassName)) {
                throw new TapestryException(PageloadMessages.missingComponentType(), location, null);
            }
            EmbeddedComponentAssemblerImpl embedded = new EmbeddedComponentAssemblerImpl(this.assemblerSource, this.instantiatorSource, this.componentClassResolver, componentClassName, this.getSelector(), embeddedModel, mixins, location);
            if (this.embeddedIdToAssembler == null) {
                this.embeddedIdToAssembler = CollectionFactory.newMap();
            }
            this.embeddedIdToAssembler.put(embeddedId, embedded);
            if (embeddedModel != null) {
                for (String publishedParameterName : embeddedModel.getPublishedParameters()) {
                    String existingEmbeddedId;
                    if (this.publishedParameterToEmbeddedId == null) {
                        this.publishedParameterToEmbeddedId = CollectionFactory.newCaseInsensitiveMap();
                    }
                    if ((existingEmbeddedId = this.publishedParameterToEmbeddedId.get(publishedParameterName)) != null) {
                        throw new TapestryException(PageloadMessages.parameterAlreadyPublished(publishedParameterName, embeddedId, this.instantiator.getModel().getComponentClassName(), existingEmbeddedId), location, null);
                    }
                    this.publishedParameterToEmbeddedId.put(publishedParameterName, embeddedId);
                }
            }
            return embedded;
        }
        catch (Exception ex) {
            throw new TapestryException(PageloadMessages.failureCreatingEmbeddedComponent(embeddedId, this.instantiator.getModel().getComponentClassName(), InternalUtils.toMessage((Throwable)ex)), location, (Throwable)ex);
        }
    }

    @Override
    public ParameterBinder getBinder(String parameterName) {
        final String embeddedId = (String)InternalUtils.get(this.publishedParameterToEmbeddedId, (Object)parameterName);
        if (embeddedId == null) {
            return null;
        }
        EmbeddedComponentAssembler embededdedComponentAssembler = this.embeddedIdToAssembler.get(embeddedId);
        ComponentAssembler embeddedAssembler = embededdedComponentAssembler.getComponentAssembler();
        final ParameterBinder embeddedBinder = embeddedAssembler.getBinder(parameterName);
        if (embeddedBinder != null) {
            return new ParameterBinder(){

                public void bind(ComponentPageElement element, Binding binding) {
                    ComponentPageElement subelement = element.getEmbeddedElement(embeddedId);
                    embeddedBinder.bind(subelement, binding);
                }

                public String getDefaultBindingPrefix(String metaDefault) {
                    return embeddedBinder.getDefaultBindingPrefix(metaDefault);
                }
            };
        }
        final ParameterBinder innerBinder = embededdedComponentAssembler.createParameterBinder(parameterName);
        if (innerBinder == null) {
            String message = PageloadMessages.publishedParameterNonexistant(parameterName, this.instantiator.getModel().getComponentClassName(), embeddedId);
            throw new TapestryException(message, embededdedComponentAssembler.getLocation(), null);
        }
        return new ParameterBinder(){

            public void bind(ComponentPageElement element, Binding binding) {
                ComponentPageElement subelement = element.getEmbeddedElement(embeddedId);
                innerBinder.bind(subelement, binding);
            }

            public String getDefaultBindingPrefix(String metaDefault) {
                return innerBinder.getDefaultBindingPrefix(metaDefault);
            }
        };
    }

    @Override
    public ComponentResourceSelector getSelector() {
        return this.resources.getSelector();
    }

    public String toString() {
        return String.format("ComponentAssembler[%s %s]", this.instantiator.getModel().getComponentClassName(), this.getSelector());
    }
}

