/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.renderers;

import java.util.List;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ioc.annotations.Primary;
import org.apache.tapestry5.services.Context;
import org.apache.tapestry5.services.ObjectRenderer;
import org.apache.tapestry5.services.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestRenderer
implements ObjectRenderer<Request> {
    private final Context context;
    private final ObjectRenderer masterObjectRenderer;

    public RequestRenderer(@Primary ObjectRenderer masterObjectRenderer, Context context) {
        this.masterObjectRenderer = masterObjectRenderer;
        this.context = context;
    }

    @Override
    public void render(Request request, MarkupWriter writer) {
        writer.element("dl", new Object[0]);
        this.dt(writer, "Context Path");
        writer.element("dd", new Object[0]);
        String contextPath = request.getContextPath();
        if (contextPath.equals("")) {
            writer.element("em", new Object[0]);
            writer.write("none (deployed as root)");
            writer.end();
        } else {
            writer.write(contextPath);
        }
        writer.end();
        this.dt(writer, "Request Path");
        this.dd(writer, request.getPath());
        this.dt(writer, "Locale");
        this.dd(writer, request.getLocale().toString());
        this.dt(writer, "Secure");
        this.dd(writer, Boolean.toString(request.isSecure()));
        this.dt(writer, "Server Name");
        this.dd(writer, request.getServerName());
        writer.end();
        this.parameters(request, writer);
        this.headers(request, writer);
        this.context(writer);
    }

    private void context(MarkupWriter writer) {
        List<String> attributeNames = this.context.getAttributeNames();
        if (attributeNames.isEmpty()) {
            return;
        }
        this.section(writer, "Context Attributes");
        writer.element("dl", new Object[0]);
        for (String name : attributeNames) {
            this.dt(writer, name);
            writer.element("dd", new Object[0]);
            this.masterObjectRenderer.render(this.context.getAttribute(name), writer);
            writer.end();
        }
        writer.end();
    }

    private void parameters(Request request, MarkupWriter writer) {
        List<String> parameterNames = request.getParameterNames();
        if (parameterNames.isEmpty()) {
            return;
        }
        this.section(writer, "Query Parameters");
        writer.element("dl", new Object[0]);
        for (String name : parameterNames) {
            String[] values = request.getParameters(name);
            this.dt(writer, name);
            writer.element("dd", new Object[0]);
            if (values.length > 1) {
                writer.element("ul", new Object[0]);
                for (String value : values) {
                    writer.element("li", new Object[0]);
                    writer.write(value);
                    writer.end();
                }
                writer.end();
            } else {
                writer.write(values[0]);
            }
            writer.end();
        }
        writer.end();
    }

    private void dt(MarkupWriter writer, String name) {
        writer.element("dt", new Object[0]);
        writer.write(name);
        writer.end();
    }

    private void dd(MarkupWriter writer, String name) {
        writer.element("dd", new Object[0]);
        writer.write(name);
        writer.end();
    }

    private void section(MarkupWriter writer, String name) {
        writer.element("div", "class", "t-env-data-section");
        writer.write(name);
        writer.end();
    }

    private void headers(Request request, MarkupWriter writer) {
        this.section(writer, "Headers");
        writer.element("dl", new Object[0]);
        for (String name : request.getHeaderNames()) {
            this.dt(writer, name);
            this.dd(writer, request.getHeader(name));
        }
        writer.end();
    }
}

