/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import org.apache.tapestry5.internal.services.AssetResourceLocator;
import org.apache.tapestry5.internal.services.ResourceDigestManager;
import org.apache.tapestry5.internal.services.ServicesMessages;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.Response;

public class AssetResourceLocatorImpl
implements AssetResourceLocator {
    private final ResourceDigestManager digestManager;
    private final Response response;
    private final AssetSource assetSource;

    public AssetResourceLocatorImpl(ResourceDigestManager digestManager, Response response, AssetSource assetSource) {
        this.digestManager = digestManager;
        this.response = response;
        this.assetSource = assetSource;
    }

    public Resource findClasspathResourceForPath(String path) throws IOException {
        Resource resource = this.assetSource.resourceForPath(path);
        if (!this.digestManager.requiresDigest(resource)) {
            return resource;
        }
        return this.validateChecksumOfClasspathResource(resource);
    }

    private Resource validateChecksumOfClasspathResource(Resource resource) throws IOException {
        int prevdotx;
        String file = resource.getFile();
        boolean valid = false;
        Resource result = resource;
        int lastdotx = file.lastIndexOf(46);
        if (lastdotx > 0 && (prevdotx = file.lastIndexOf(46, lastdotx - 1)) > 0) {
            String requestDigest = file.substring(prevdotx + 1, lastdotx);
            String realFile = file.substring(0, prevdotx) + file.substring(lastdotx);
            result = resource.forFile(realFile);
            String actualDigest = this.digestManager.getDigest(result);
            valid = requestDigest.equals(actualDigest);
        }
        if (valid) {
            return result;
        }
        this.response.sendError(403, ServicesMessages.wrongAssetDigest(result));
        return null;
    }
}

