/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.beaneditor.NonVisual;
import org.apache.tapestry5.beaneditor.ReorderProperties;
import org.apache.tapestry5.internal.beaneditor.BeanModelImpl;
import org.apache.tapestry5.internal.beaneditor.BeanModelUtils;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.annotations.Primary;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ClassFactory;
import org.apache.tapestry5.ioc.services.ClassPropertyAdapter;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.PropertyAdapter;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.services.BeanModelSource;
import org.apache.tapestry5.services.ComponentLayer;
import org.apache.tapestry5.services.DataTypeAnalyzer;
import org.apache.tapestry5.services.PropertyConduitSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanModelSourceImpl
implements BeanModelSource {
    private final TypeCoercer typeCoercer;
    private final PropertyAccess propertyAccess;
    private final PropertyConduitSource propertyConduitSource;
    private final ClassFactory classFactory;
    private final DataTypeAnalyzer dataTypeAnalyzer;
    private final ObjectLocator locator;

    private void orderProperties(ClassPropertyAdapter classAdapter, List<String> propertyNames) {
        List properties = CollectionFactory.newList();
        for (String name : propertyNames) {
            PropertyAdapter pa = classAdapter.getPropertyAdapter(name);
            Method readMethod = pa.getReadMethod();
            Location location = readMethod == null ? null : this.classFactory.getMethodLocation(readMethod);
            int line = location == null ? -1 : location.getLine();
            properties.add(new PropertyOrder(name, BeanModelSourceImpl.computeDepth(pa), line));
        }
        Collections.sort(properties);
        propertyNames.clear();
        for (PropertyOrder po : properties) {
            propertyNames.add(po.propertyName);
        }
    }

    private static int computeDepth(PropertyAdapter pa) {
        int depth = 0;
        for (Class c = pa.getDeclaringClass(); c != null && c != Object.class; c = c.getSuperclass()) {
            ++depth;
        }
        return depth;
    }

    public BeanModelSourceImpl(TypeCoercer typeCoercer, PropertyAccess propertyAccess, PropertyConduitSource propertyConduitSource, @ComponentLayer ClassFactory classFactory, @Primary DataTypeAnalyzer dataTypeAnalyzer, ObjectLocator locator) {
        this.typeCoercer = typeCoercer;
        this.propertyAccess = propertyAccess;
        this.propertyConduitSource = propertyConduitSource;
        this.classFactory = classFactory;
        this.dataTypeAnalyzer = dataTypeAnalyzer;
        this.locator = locator;
    }

    @Override
    public <T> BeanModel<T> createDisplayModel(Class<T> beanClass, Messages messages) {
        return this.create(beanClass, false, messages);
    }

    @Override
    public <T> BeanModel<T> createEditModel(Class<T> beanClass, Messages messages) {
        return this.create(beanClass, true, messages);
    }

    @Override
    public <T> BeanModel<T> create(Class<T> beanClass, boolean filterReadOnlyProperties, Messages messages) {
        assert (beanClass != null);
        assert (messages != null);
        ClassPropertyAdapter adapter = this.propertyAccess.getAdapter(beanClass);
        BeanModelImpl<T> model = new BeanModelImpl<T>(beanClass, this.propertyConduitSource, this.typeCoercer, messages, this.locator);
        for (String propertyName : adapter.getPropertyNames()) {
            String dataType;
            PropertyAdapter pa = adapter.getPropertyAdapter(propertyName);
            if (!pa.isRead() || this.isStaticFieldProperty(pa) || pa.getAnnotation(NonVisual.class) != null || filterReadOnlyProperties && !pa.isUpdate() || (dataType = this.dataTypeAnalyzer.identifyDataType(pa)) == null) continue;
            model.add(propertyName).dataType(dataType);
        }
        List<String> propertyNames = model.getPropertyNames();
        this.orderProperties(adapter, propertyNames);
        model.reorder(propertyNames.toArray(new String[propertyNames.size()]));
        ReorderProperties reorderAnnotation = beanClass.getAnnotation(ReorderProperties.class);
        if (reorderAnnotation != null) {
            BeanModelUtils.reorder(model, reorderAnnotation.value());
        }
        return model;
    }

    private boolean isStaticFieldProperty(PropertyAdapter adapter) {
        return adapter.isField() && Modifier.isStatic(adapter.getField().getModifiers());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertyOrder
    implements Comparable<PropertyOrder> {
        final String propertyName;
        final int classDepth;
        final int sortKey;

        public PropertyOrder(String propertyName, int classDepth, int sortKey) {
            this.propertyName = propertyName;
            this.classDepth = classDepth;
            this.sortKey = sortKey;
        }

        @Override
        public int compareTo(PropertyOrder o) {
            int result = this.classDepth - o.classDepth;
            if (result == 0) {
                result = this.sortKey - o.sortKey;
            }
            if (result == 0) {
                result = this.propertyName.compareTo(o.propertyName);
            }
            return result;
        }
    }
}

