/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.util.AvailableValues;
import org.apache.tapestry5.ioc.util.UnknownValueException;
import org.apache.tapestry5.services.ClasspathAssetAliasManager;
import org.apache.tapestry5.services.assets.AssetPathConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathAssetAliasManagerImpl
implements ClasspathAssetAliasManager {
    private final AssetPathConstructor assetPathConstructor;
    private final Map<String, String> aliasToPathPrefix = CollectionFactory.newMap();
    private final Map<String, String> pathPrefixToAlias = CollectionFactory.newMap();
    private final List<String> sortedAliases;
    private final List<String> sortedPathPrefixes;

    public ClasspathAssetAliasManagerImpl(AssetPathConstructor assetPathConstructor, Map<String, String> configuration) {
        this.assetPathConstructor = assetPathConstructor;
        for (Map.Entry<String, String> e : configuration.entrySet()) {
            String alias = this.verify("folder name", e.getKey());
            String path = this.verify("path", e.getValue());
            this.aliasToPathPrefix.put(alias, path);
            this.pathPrefixToAlias.put(path, alias);
        }
        Comparator<String> sortDescendingByLength = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        };
        this.sortedAliases = CollectionFactory.newList(this.aliasToPathPrefix.keySet());
        Collections.sort(this.sortedAliases, sortDescendingByLength);
        this.sortedPathPrefixes = CollectionFactory.newList(this.aliasToPathPrefix.values());
        Collections.sort(this.sortedPathPrefixes, sortDescendingByLength);
    }

    private String verify(String name, String input) {
        if (input.startsWith("/") || input.endsWith("/")) {
            throw new RuntimeException(String.format("Contribution of %s '%s' is invalid as it may not start with or end with a slash.", name, input));
        }
        return input;
    }

    @Override
    public String toClientURL(String resourcePath) {
        for (String pathPrefix : this.sortedPathPrefixes) {
            if (!resourcePath.startsWith(pathPrefix)) continue;
            String virtualFolder = this.pathPrefixToAlias.get(pathPrefix);
            String virtualPath = resourcePath.substring(pathPrefix.length() + 1);
            return this.assetPathConstructor.constructAssetPath(virtualFolder, virtualPath);
        }
        throw new UnknownValueException(String.format("Unable to create a client URL for classpath resource %s: The resource path was not within an aliased path.", resourcePath), new AvailableValues("Aliased paths", this.aliasToPathPrefix.values()));
    }

    @Override
    public Map<String, String> getMappings() {
        return Collections.unmodifiableMap(this.aliasToPathPrefix);
    }
}

