/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.internal.EmptyEventContext;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.URLEventContext;
import org.apache.tapestry5.internal.services.ArrayEventContext;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.services.ContextPathEncoder;
import org.apache.tapestry5.services.ContextValueEncoder;
import org.apache.tapestry5.services.URLEncoder;

public class ContextPathEncoderImpl
implements ContextPathEncoder {
    private static final int BUFFER_SIZE = 100;
    private final ContextValueEncoder valueEncoder;
    private final URLEncoder urlEncoder;
    private final TypeCoercer typeCoercer;
    private final EventContext EMPTY = new EmptyEventContext();

    public ContextPathEncoderImpl(ContextValueEncoder valueEncoder, URLEncoder urlEncoder, TypeCoercer typeCoercer) {
        this.valueEncoder = valueEncoder;
        this.urlEncoder = urlEncoder;
        this.typeCoercer = typeCoercer;
    }

    public String encodeValue(Object value) {
        String valueEncoded = value == null ? null : this.valueEncoder.toClient(value);
        return this.urlEncoder.encode(valueEncoded);
    }

    public String encodeIntoPath(Object[] context) {
        if (context == null || context.length == 0) {
            return "";
        }
        return this.encodeIntoPath(new ArrayEventContext(this.typeCoercer, context));
    }

    public String encodeIntoPath(EventContext context) {
        assert (context != null);
        int count = context.getCount();
        StringBuilder output = new StringBuilder(100);
        for (int i = 0; i < count; ++i) {
            Object raw = context.get(Object.class, i);
            String urlEncoded = this.encodeValue(raw);
            if (i > 0) {
                output.append("/");
            }
            output.append(urlEncoded);
        }
        return output.toString();
    }

    public EventContext decodePath(String path) {
        if (InternalUtils.isBlank((String)path)) {
            return this.EMPTY;
        }
        String[] split = TapestryInternalUtils.splitPath(path);
        for (int i = 0; i < split.length; ++i) {
            split[i] = this.urlEncoder.decode(split[i]);
        }
        return new URLEventContext(this.valueEncoder, split);
    }
}

