/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.lang.reflect.Method;
import org.apache.tapestry5.ioc.services.Builtin;
import org.apache.tapestry5.ioc.services.PlasticProxyFactory;
import org.apache.tapestry5.plastic.ClassInstantiator;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticClassTransformer;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.plastic.PlasticUtils;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.EnvironmentalShadowBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentalShadowBuilderImpl
implements EnvironmentalShadowBuilder {
    private final PlasticProxyFactory proxyFactory;
    private final Environment environment;

    public EnvironmentalShadowBuilderImpl(@Builtin PlasticProxyFactory proxyFactory, Environment environment) {
        this.proxyFactory = proxyFactory;
        this.environment = environment;
    }

    @Override
    public <T> T build(final Class<T> serviceType) {
        ClassInstantiator instantiator = this.proxyFactory.createProxy(serviceType, new PlasticClassTransformer(){

            public void transform(PlasticClass plasticClass) {
                PlasticMethod delegateMethod = plasticClass.introducePrivateMethod(PlasticUtils.toTypeName((Class)serviceType), "delegate", null, null);
                delegateMethod.addAdvice(new MethodAdvice(){

                    public void advise(MethodInvocation invocation) {
                        invocation.setReturnValue(EnvironmentalShadowBuilderImpl.this.environment.peekRequired(serviceType));
                    }
                });
                for (Method method : serviceType.getMethods()) {
                    plasticClass.introduceMethod(method).delegateTo(delegateMethod);
                }
                plasticClass.addToString(String.format("<EnvironmentalProxy for %s>", serviceType.getName()));
            }
        });
        return (T)instantiator.newInstance();
    }
}

