/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.List;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.services.ArrayEventContext;
import org.apache.tapestry5.internal.services.LinkSource;
import org.apache.tapestry5.internal.services.PageActivationContextCollector;
import org.apache.tapestry5.internal.services.PageRenderQueue;
import org.apache.tapestry5.internal.services.RequestPageCache;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.ComponentEventLinkEncoder;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.LinkCreationHub;
import org.apache.tapestry5.services.LinkCreationListener;
import org.apache.tapestry5.services.LinkCreationListener2;
import org.apache.tapestry5.services.PageRenderRequestParameters;
import org.apache.tapestry5.services.RequestGlobals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkSourceImpl
implements LinkSource,
LinkCreationHub {
    private final PageRenderQueue pageRenderQueue;
    private final PageActivationContextCollector contextCollector;
    private final ComponentEventLinkEncoder linkEncoder;
    private final List<LinkCreationListener2> listeners = CollectionFactory.newThreadSafeList();
    private final TypeCoercer typeCoercer;
    private final ComponentClassResolver resolver;
    private final RequestGlobals requestGlobals;
    private final RequestPageCache pageCache;

    public LinkSourceImpl(PageRenderQueue pageRenderQueue, PageActivationContextCollector contextCollector, TypeCoercer typeCoercer, ComponentClassResolver resolver, ComponentEventLinkEncoder linkEncoder, RequestGlobals requestGlobals, RequestPageCache pageCache, List<LinkCreationListener2> configuration) {
        this.pageRenderQueue = pageRenderQueue;
        this.contextCollector = contextCollector;
        this.typeCoercer = typeCoercer;
        this.resolver = resolver;
        this.linkEncoder = linkEncoder;
        this.requestGlobals = requestGlobals;
        this.pageCache = pageCache;
        this.listeners.addAll(configuration);
    }

    @Override
    public Link createComponentEventLink(Page page, String nestedId, String eventType, boolean forForm, Object ... eventContext) {
        assert (page != null);
        assert (InternalUtils.isNonBlank((String)eventType));
        Page activePage = this.pageRenderQueue.getRenderingPage();
        if (activePage == null) {
            activePage = page;
        }
        String activePageName = activePage.getName();
        Object[] pageActivationContext = this.contextCollector.collectPageActivationContext(activePageName);
        ComponentEventRequestParameters parameters = new ComponentEventRequestParameters(activePageName, page.getName(), this.toBlank(nestedId), eventType, new ArrayEventContext(this.typeCoercer, pageActivationContext), new ArrayEventContext(this.typeCoercer, eventContext));
        Link link = this.linkEncoder.createComponentEventLink(parameters, forForm);
        for (LinkCreationListener2 listener : this.listeners) {
            listener.createdComponentEventLink(link, parameters);
        }
        return link;
    }

    private String toBlank(String input) {
        return input == null ? "" : input;
    }

    @Override
    public Link createPageRenderLink(String pageName, boolean override, Object ... pageActivationContext) {
        String canonical = this.resolver.canonicalizePageName(pageName);
        Object[] context = override || pageActivationContext.length != 0 ? pageActivationContext : this.contextCollector.collectPageActivationContext(canonical);
        boolean loopback = canonical.equals(this.requestGlobals.getActivePageName()) && this.pageCache.get(pageName).hasResetListeners();
        PageRenderRequestParameters parameters = new PageRenderRequestParameters(canonical, new ArrayEventContext(this.typeCoercer, context), loopback);
        Link link = this.linkEncoder.createPageRenderLink(parameters);
        for (LinkCreationListener2 listener : this.listeners) {
            listener.createdPageRenderLink(link, parameters);
        }
        return link;
    }

    @Override
    public LinkCreationHub getLinkCreationHub() {
        return this;
    }

    @Override
    public void addListener(LinkCreationListener listener) {
        assert (listener != null);
        this.addListener(TapestryInternalUtils.toLinkCreationListener2(listener));
    }

    @Override
    public void addListener(LinkCreationListener2 listener) {
        assert (listener != null);
        this.listeners.add(listener);
    }
}

