/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.internal.event.InvalidationEventHubImpl;
import org.apache.tapestry5.internal.services.MapMessages;
import org.apache.tapestry5.internal.services.MessagesBundle;
import org.apache.tapestry5.internal.services.MessagesSource;
import org.apache.tapestry5.internal.services.ServicesMessages;
import org.apache.tapestry5.internal.util.MultiKey;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.URLChangeTracker;
import org.apache.tapestry5.services.messages.PropertiesFileParser;
import org.apache.tapestry5.services.pageload.ComponentResourceLocator;
import org.apache.tapestry5.services.pageload.ComponentResourceSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagesSourceImpl
extends InvalidationEventHubImpl
implements MessagesSource {
    private final URLChangeTracker tracker;
    private final PropertiesFileParser propertiesFileParser;
    private final ComponentResourceLocator resourceLocator;
    private final Map<MultiKey, Messages> messagesByBundleIdAndSelector = CollectionFactory.newConcurrentMap();
    private final Map<MultiKey, Map<String, String>> cookedProperties = CollectionFactory.newConcurrentMap();
    private final Map<Resource, Map<String, String>> rawProperties = CollectionFactory.newConcurrentMap();
    private final Map<String, String> emptyMap = Collections.emptyMap();

    public MessagesSourceImpl(boolean productionMode, URLChangeTracker tracker, ComponentResourceLocator resourceLocator, PropertiesFileParser propertiesFileParser) {
        super(productionMode);
        this.tracker = tracker;
        this.propertiesFileParser = propertiesFileParser;
        this.resourceLocator = resourceLocator;
    }

    public void checkForUpdates() {
        if (this.tracker != null && this.tracker.containsChanges()) {
            this.messagesByBundleIdAndSelector.clear();
            this.cookedProperties.clear();
            this.rawProperties.clear();
            this.tracker.clear();
            this.fireInvalidationEvent();
        }
    }

    @Override
    public Messages getMessages(MessagesBundle bundle, ComponentResourceSelector selector) {
        MultiKey key = new MultiKey(bundle.getId(), selector);
        Messages result = this.messagesByBundleIdAndSelector.get(key);
        if (result == null) {
            result = this.buildMessages(bundle, selector);
            this.messagesByBundleIdAndSelector.put(key, result);
        }
        return result;
    }

    private Messages buildMessages(MessagesBundle bundle, ComponentResourceSelector selector) {
        Map<String, String> properties = this.findBundleProperties(bundle, selector);
        return new MapMessages(selector.locale, properties);
    }

    private Map<String, String> findBundleProperties(MessagesBundle bundle, ComponentResourceSelector selector) {
        if (bundle == null) {
            return this.emptyMap;
        }
        MultiKey key = new MultiKey(bundle.getId(), selector);
        Map<String, String> existing = this.cookedProperties.get(key);
        if (existing != null) {
            return existing;
        }
        Resource propertiesResource = bundle.getBaseResource().withExtension("properties");
        List<Resource> localizations = this.resourceLocator.locateMessageCatalog(propertiesResource, selector);
        Map<String, String> previous = this.findBundleProperties(bundle.getParent(), selector);
        for (Resource localization : (Flow)F.flow(localizations).reverse()) {
            Map<String, String> rawProperties = this.getRawProperties(localization);
            previous = this.extend(previous, rawProperties);
        }
        this.cookedProperties.put(key, previous);
        return previous;
    }

    private Map<String, String> extend(Map<String, String> base, Map<String, String> rawProperties) {
        if (rawProperties.isEmpty()) {
            return base;
        }
        Map result = CollectionFactory.newCaseInsensitiveMap(base);
        result.putAll(rawProperties);
        return result;
    }

    private Map<String, String> getRawProperties(Resource localization) {
        Map<String, String> result = this.rawProperties.get(localization);
        if (result == null) {
            result = this.readProperties(localization);
            this.rawProperties.put(localization, result);
        }
        return result;
    }

    private Map<String, String> readProperties(Resource resource) {
        if (!resource.exists()) {
            return this.emptyMap;
        }
        if (this.tracker != null) {
            this.tracker.add(resource.toURL());
        }
        try {
            return this.propertiesFileParser.parsePropertiesFile(resource);
        }
        catch (Exception ex) {
            throw new RuntimeException(ServicesMessages.failureReadingMessages(resource, ex), ex);
        }
    }
}

