/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Map;
import org.apache.tapestry5.internal.services.PageSource;
import org.apache.tapestry5.internal.services.RequestPageCache;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.annotations.Scope;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.ioc.services.ThreadCleanupListener;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.slf4j.Logger;

@Scope(value="perthread")
public class NonPoolingRequestPageCacheImpl
implements RequestPageCache,
ThreadCleanupListener {
    private final Logger logger;
    private final ComponentClassResolver resolver;
    private final PageSource pageSource;
    private final Map<String, Page> cache = CollectionFactory.newMap();

    public NonPoolingRequestPageCacheImpl(Logger logger, ComponentClassResolver resolver, PageSource pageSource) {
        this.logger = logger;
        this.resolver = resolver;
        this.pageSource = pageSource;
    }

    @PostInjection
    public void listenForThreadCleanup(PerthreadManager perthreadManager) {
        perthreadManager.addThreadCleanupListener((ThreadCleanupListener)this);
    }

    public void threadDidCleanup() {
        for (Page page : this.cache.values()) {
            try {
                page.detached();
            }
            catch (Throwable t) {
                this.logger.error(String.format("Error detaching page %s: %s", page, InternalUtils.toMessage((Throwable)t)), t);
            }
        }
    }

    public Page get(String pageName) {
        String canonical = this.resolver.canonicalizePageName(pageName);
        Page page = this.cache.get(canonical);
        if (page == null) {
            page = this.pageSource.getPage(canonical);
            try {
                page.attached();
            }
            catch (Throwable t) {
                throw new RuntimeException(String.format("Unable to attach page %s: %s", canonical, InternalUtils.toMessage((Throwable)t)), t);
            }
            this.cache.put(canonical, page);
        }
        return page;
    }
}

