/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.ContentType;
import org.apache.tapestry5.internal.services.PageContentTypeAnalyzer;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.MetaDataLocator;

public class PageContentTypeAnalyzerImpl
implements PageContentTypeAnalyzer {
    private final MetaDataLocator metaDataLocator;
    private final String outputCharset;

    public PageContentTypeAnalyzerImpl(MetaDataLocator metaDataLocator, @Symbol(value="tapestry.charset") String outputCharset) {
        this.metaDataLocator = metaDataLocator;
        this.outputCharset = outputCharset;
    }

    public ContentType findContentType(Page page) {
        ComponentResources pageResources = page.getRootComponent().getComponentResources();
        String contentTypeString = this.metaDataLocator.findMeta("tapestry.response-content-type", pageResources, String.class);
        return new ContentType(contentTypeString, this.outputCharset);
    }
}

